<?php

namespace App\Http\Controllers;

use App\Models\CommantaireEpilation;
use Illuminate\Http\Request;
use App\Models\Prospect;
class CommantaireEpilationController extends Controller
{
    public function index($prospect_id)
    {
        $prospects = Prospect::all();
        $prospect = Prospect::find($prospect_id);
        return view('fiche_clients.index', compact( 'prospects', 'prospect'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'prospect_id' => 'required|exists:prospects,id',
            'commentairEp' => 'required|string',
        ]);
    
        // Create a new CommantaireEpilation instance with the provided data
        $commantaireEpilation = new CommantaireEpilation([
            'prospect_id' => $request->prospect_id,
            'commentairEp' => $request->commentairEp,
        ]);
    
        // Save the CommantaireEpilation instance
        $commantaireEpilation->save();
    
        // Retrieve the prospect associated with the comment (assuming prospect_id is required)
        $prospect = Prospect::findOrFail($request->prospect_id);
    
        return redirect()->route('fiche_clients.index', ['prospect_id' => $request->prospect_id])
            ->with('success', 'Commantaire Epilation created successfully.');
    }
    

    public function edit(CommantaireEpilation $commantaireEpilation)
    {
        return view('commantaire_epilations.edit', compact('commantaireEpilation'));
    }

    public function update(Request $request, CommantaireEpilation $commantaireEpilation)
    {
        $commantaireEpilation->update([
            'commentairEp' => $request->commentairEp,
            // Update other fields as needed
        ]);
    
        return redirect()->route('fiche_clients.index', ['prospect_id' => $commantaireEpilation->prospect_id])
            ->with('success', 'Commantaire Epilation updated successfully.');
    }
    
    

    public function destroy(CommantaireEpilation $commantaireEpilation)
    {
        $commantaireEpilation->delete();

        return redirect()->route('fiche_clients.index', ['prospect_id' => $commantaireEpilation->prospect_id])
            ->with('success', 'Commantaire Epilation deleted successfully.');
    }
}
