<?php

namespace App\Http\Controllers;

use App\Models\CommentaireMiniceur;
use App\Models\Prospect;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CommentaireMiniceurController extends Controller
{
    public function index($prospect_id)
    {
        $prospects = Prospect::all();
        $prospect = Prospect::find($prospect_id);
        return view('ficheminiceurs.index', compact( 'prospects', 'prospect'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'prospect_id' => 'required|exists:prospects,id',
            'commentaireMiniceur' => 'required|string',
        ]);
    
        // Create a new CommentaireMiniceur instance with the provided data
        $commentaireMiniceur = new CommentaireMiniceur([
            'prospect_id' => $request->prospect_id,
            'commentairMn' => $request->commentaireMiniceur,
        ]);
    
        // Save the CommentaireMiniceur instance
        $commentaireMiniceur->save();
    
        return redirect()->route('ficheminiceurs.index', ['prospect_id' => $request->prospect_id])
            ->with('success', 'Commentaire Miniceur created successfully.');
    }
    
    public function edit(CommentaireMiniceur $commentaireMiniceur)
    {
        return view('commentaire_miniceurs.edit', compact('commentaireMiniceur'));
    }
    public function update(Request $request, CommentaireMiniceur $commentaireMiniceur)
    {
        $commentaireMiniceur->update([
            'commentairMn' => $request->commentaireMiniceur,
        ]);
    
        return redirect()->route('ficheminiceurs.index', ['prospect_id' => $commentaireMiniceur->prospect_id])
            ->with('success', 'Commentaire Miniceur updated successfully.');
    }
    
    public function destroy(CommentaireMiniceur $commentaireMiniceur)
    {
        $prospectId = $commentaireMiniceur->prospect_id;
        $commentaireMiniceur->delete();

        return redirect()->route('ficheminiceurs.index', ['prospect_id' => $prospectId])
            ->with('success', 'Commentaire Miniceur deleted successfully.');
    }
    public function __construct()
{
    $this->middleware('role:admin')->only(['edit','update','destroy']);
}
}
