<?php

namespace App\Http\Controllers;

use App\Models\FicheClient;
use Illuminate\Http\Request;
use App\Models\Prospect;
use App\Models\CommantaireEpilation;
class FicheClientController extends Controller
{
    public function index($prospect_id)
    {
        $prospects = Prospect::all();
        $ficheClients = FicheClient::where('prospect_id', $prospect_id)->get();
        $ficheCliens = FicheClient::all();
        $commantaires = CommantaireEpilation::all(); // Retrieve all commantaires

        // Charger les commantaires pour chaque fiche client
        
        
        // Fetch the prospect using the $prospect_id
        $prospect = Prospect::find($prospect_id);
        $comments = CommantaireEpilation::where('prospect_id', $prospect_id)->get();

        // Pass $prospect and $commantaires to the view
        return view('fiche_clients.index', compact('ficheClients','ficheCliens', 'prospects', 'prospect', 'commantaires','comments'));
    }
    public function create()
    {
        $prospects = Prospect::all();
        
        return view('fiche_clients.create', compact('prospects'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required',
            'parametre' => 'required',
            // Add validation rules for other fields here...
        ]);

        // Create a new FicheClient instance
        $ficheClient = new FicheClient([
            'date' => $request->date,
            'parametre' => $request->parametre,
            'prospect_id' => $request->prospect_id,
            // Add other fields here...
        ]);

        // Save the FicheClient instance
        $ficheClient->save();
        return redirect()->route('fiche_clients.index', ['prospect_id' => $request->prospect_id])
        ->with('success', 'FicheClient created successfully.');
    
    }

    public function show(FicheClient $ficheClient)
    {
        return view('fiche_clients.show', compact('ficheClient'));
    }

    public function edit(FicheClient $ficheClient)
    {
        return view('fiche_clients.edit', compact('ficheClient'));
    }

    public function update(Request $request, FicheClient $ficheClient)
    {
        $request->validate([
            'date' => 'required',
            'parametre' => 'required',
            // Add validation rules for other fields here...
        ]);

        $ficheClient->update([
            'date' => $request->date,
            'parametre' => $request->parametre,
            // Update other fields as needed...
        ]);

        return redirect()->route('fiche_clients.index', ['prospect_id' => $request->prospect_id])
            ->with('success', 'FicheClient updated successfully');
    }

    public function destroy(FicheClient $ficheClient)
    {
        $prospectId = $ficheClient->prospect_id; // Get the prospect_id from the FicheClient object
        $ficheClient->delete();
    
        return redirect()->route('fiche_clients.index', ['prospect_id' => $prospectId])
            ->with('success', 'FicheClient deleted successfully');
    }
    public function __construct()
{
    $this->middleware('role:admin')->only(['edit','update','destroy']);
}
    
}