<?php

namespace App\Http\Controllers;

use App\Models\FicheMiniceur;
use Illuminate\Http\Request;
use App\Models\Prospect;
use App\Models\CommentaireMiniceur;

class FicheMiniceurController extends Controller
{
    // // Display a listing of the resource.
    // public function index(Request $request)
    // {
    //     $prospectId = $request->input('prospect_id');
    //     $ficheminiceurs = FicheMiniceur::where('prospect_id', $prospectId)->get();
    //     $prospects = Prospect::all(); // Assuming you need to pass all prospects for some purpose
    
    //     return view('ficheminiceurs.index', compact('ficheminiceurs', 'prospects'));
    // }
    public function index($prospect_id)
    {
        $ficheminiceus = FicheMiniceur::all();

        $prospects = Prospect::all();
        $ficheminiceurs = FicheMiniceur::where('prospect_id', $prospect_id)->get();
        $commantaires = CommentaireMiniceur::all(); // Retrieve all commantaires

        // Fetch the prospect using the $prospect_id
        $prospect = Prospect::find($prospect_id);
        $comments = CommentaireMiniceur::where('prospect_id', $prospect_id)->get();

        // Pass $prospect to the view
        return view('ficheminiceurs.index', compact('ficheminiceurs', 'prospects', 'prospect', 'commantaires','comments'));
    }
    // Show the form for creating a new resource.
    public function create()
    {
        $prospects = Prospect::all();

        return view('ficheminiceurs.create', compact('prospects'));
    }

    // Store a newly created resource in storage.
  // Store a newly created resource in storage.
public function store(Request $request)
{
    $request->validate([
        'date' => 'required|date',
        'prestation' => 'required|string',
        'vente_1' => 'required|integer',
        'vente_2' => 'required|integer',
        'vente_3' => 'required|integer',
        'cuise_1' => 'required|string',
        'cuise_2' => 'required|string',
        'cuise_3' => 'required|string',
        // Add validation rules for custom fields here
    ]);

    // Create the Fiche Miniceur
    $ficheMiniceur = FicheMiniceur::create($request->all());

    return redirect()->route('ficheminiceurs.index', ['prospect_id' => $ficheMiniceur->prospect_id])
                     ->with('success', 'Fiche Miniceur created successfully.');
}


    // Display the specified resource.
    public function show($id)
    {
        $ficheMiniceur = FicheMiniceur::findOrFail($id);
        return view('ficheminiceurs.show', compact('ficheMiniceur'));
    }

    // Show the form for editing the specified resource.
   // Show the form for editing the specified resource.
public function edit($id)
{
    $ficheMiniceur = FicheMiniceur::findOrFail($id);
    $prospect_id = $ficheMiniceur->prospect_id;
    $ficheminiceurs = FicheMiniceur::where('prospect_id', $prospect_id)->get();
    return view('ficheminiceurs.edit', compact('ficheMiniceur', 'ficheminiceurs'));
}

    // Update the specified resource in storage.
    public function update(Request $request, $id)
    {
        $request->validate([
            'date' => 'required|date',
            'prestation' => 'required|string',
            'vente_1' => 'required|integer',
            'vente_2' => 'required|integer',
            'vente_3' => 'required|integer',
            'cuise_1' => 'required|string',
            'cuise_2' => 'required|string',
            'cuise_3' => 'required|string',
            // Add validation rules for custom fields here
        ]);
    
        $ficheMiniceur = FicheMiniceur::findOrFail($id);
        $ficheMiniceur->update($request->all());
    
        return redirect()->route('ficheminiceurs.index', ['prospect_id' => $ficheMiniceur->prospect_id])
                         ->with('success', 'Fiche Miniceur updated successfully.');
    }
    
    // Remove the specified resource from storage.
    public function destroy($id)
    {
        $ficheMiniceur = FicheMiniceur::findOrFail($id);
        $ficheMiniceur->delete();
        return redirect()->route('ficheminiceurs.index', ['prospect_id' => $ficheMiniceur->prospect_id])->with('success', 'Fiche Miniceur deleted successfully.');
    }
    public function __construct()
{
    $this->middleware('role:admin')->only(['edit','update','destroy']);
}
}

