<?php

namespace App\Http\Controllers;

use App\Models\FichePaiement;
use Illuminate\Http\Request;
use App\Models\Prospect;
use App\Models\Rendezvous;
use App\Models\Service;

class FichePaimentController extends Controller
{
    public function index(Request $request)
    {
        $prospects = Prospect::all(); // Example: Retrieve all prospects from the database

        // Retrieve the prospect ID from the query parameter
        $prospectId = $request->query('prospect_id');
        $rendezvous = Rendezvous::where('prospect_id', $prospectId)->get();
        // Filter Fiche de Paiement records based on the prospect ID
        $fichePaiements = FichePaiement::where('prospect_id', $prospectId)->get();
        $fichePaiemens = FichePaiement::all(); // Example: Retrieve all prospects from the database
        $services = Service::all();
        // Pass the filtered records to the index view
        return view('fiche_paiements.index', compact('fichePaiements', 'prospects', 'fichePaiemens', 'rendezvous', 'services'));
    }
    public function create()
    {
        $prospects = Prospect::all();
        return view('fiche_paiements.create', compact('prospects'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required',
            'prestation' => 'required',
            'paiement' => 'required',
            'prospect_id' => 'required|exists:prospects,id',
        ]);

        FichePaiement::create($request->all());
        return redirect()->route('fiche_paiements.index', ['prospect_id' => $request->prospect_id])
        ->with('success', 'Fiche Paiement created successfully.');
    
    }
    public function show(FichePaiement $fichePaiement)
    {
        return view('fiche_paiements.show', compact('fichePaiement'));
    }


    public function edit(FichePaiement $fichePaiement)
    {
        return view('fiche_paiements.edit', compact('fichePaiement'));
    }


     public function update(Request $request, FichePaiement $fichePaiement)
{
    $request->validate([
        'date' => 'required',
        'prestation' => 'required',
        'paiement' => 'required',
        'prospect_id' => 'required|exists:prospects,id',
    ]);
    $fichePaiement->update([
        'date' => $request->date,
        'prestation' => $request->prestation,
        'paiement' => $request->paiement,
    ]);

    return redirect()->route('fiche_paiements.index', ['prospect_id' => $request->prospect_id])
        ->with('success', 'Fiche Paiement updated successfully');
}

    public function destroy(FichePaiement $fichePaiement, Request $request)
    {
        $fichePaiement->delete();
        
        return redirect()->route('fiche_paiements.index', ['prospect_id' => $fichePaiement->prospect_id])
            ->with('success', 'Fiche Paiement deleted successfully');
    }
    public function __construct()
{
    $this->middleware('role:admin')->only(['edit','update','destroy']);
}
}