<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Prospect;
use App\Models\Rendezvous;


class ProspectController extends Controller
{
// Affiche la liste des prospects
public function index()
{
    $prospects = Prospect::all();
    $rendezvous = [];
    
    foreach ($prospects as $prospect) {
        $rendezvous[$prospect->id] = Rendezvous::where('prospect_id', $prospect->id)->get();
    }
    
    return view('prospect.index', compact('prospects', 'rendezvous'));
}


// Affiche le formulaire de création d'un nouveau prospect
public function create()
{
    return view('prospect.create');
}

// Enregistre un nouveau prospect dans la base de données
public function store(Request $request)
{
    // Validation des données
    $validatedData = $request->validate([
        'telephone' => 'required|unique:prospects',
        'nom' => 'required',
        'prenom' => 'required',
        'date_naissance' => 'required|date',
        'adresse' => 'nullable',
        'email' => 'required',

    ]);

    // Création d'un nouveau prospect
    $prospect = new Prospect();
    $prospect->telephone = $request->telephone;
    $prospect->nom = $request->nom;
    $prospect->prenom = $request->prenom;
    $prospect->date_naissance = $request->date_naissance;
    $prospect->adresse = $request->adresse;
    $prospect->email = $request->email;

    $prospect->save();

    return redirect()->route('prospects.index')->with('success', 'Prospect ajouté avec succès');
}

// Affiche les détails d'un prospect spécifique
public function show($id)
{
    $prospect = Prospect::findOrFail($id);
    return view('prospect.show', ['prospect' => $prospect]);
}

// Affiche le formulaire de modification d'un prospect
public function edit($id)
{
    $prospect = Prospect::findOrFail($id);
    return view('prospect.edit', ['prospect' => $prospect]);
}

// Met à jour les informations d'un prospect dans la base de données
public function update(Request $request, $id)
{
    // Validation des données
    $validatedData = $request->validate([
        'telephone' => 'required|unique:prospects,telephone,' . $id,
        'nom' => 'required',
        'prenom' => 'required',
        'date_naissance' => 'required|date',
        'adresse' => 'nullable',
        'email' => 'required',
    ]);
    

    // Recherche du prospect à mettre à jour
    $prospect = Prospect::findOrFail($id);

    // Mise à jour des informations du prospect
    $prospect->telephone = $request->telephone;
    $prospect->nom = $request->nom;
    $prospect->prenom = $request->prenom;
    $prospect->date_naissance = $request->date_naissance;
    $prospect->adresse = $request->adresse;
    $prospect->email = $request->email;
    $prospect->save();

    return redirect()->route('prospects.index')->with('success', 'Prospect mis à jour avec succès');
}
// Supprime un prospect de la base de données
public function destroy($id)
{
    $prospect = Prospect::findOrFail($id);
    $prospect->delete();
    return redirect()->route('prospects.index')->with('success', 'Prospect supprimé avec succès');
}
public function __construct()
{
    $this->middleware('role:admin')->only(['edit','update','destroy']);
}

}
