<?php

namespace App\Http\Controllers;

use App\Models\Rendezvous;
use App\Models\Prospect;
use App\Models\Service;
use App\Models\Sousservice;
use Illuminate\Http\Request;
use Carbon\Carbon;

class RendezvousController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $rendezvous = Rendezvous::with('prospect', 'service','sousservice')->get();
        $prospects = Prospect::all(); // Assurez-vous de récupérer les prospects
        $services = Service::all(); // Assurez-vous de récupérer les services 
        $sousservices = Sousservice::all();   
        return view('rendezvous.index', compact('rendezvous', 'prospects', 'services','sousservices'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $prospects = Prospect::all();
        $services = Service::all();
        $sousservices = Sousservice::all();

        return view('rendezvous.create', compact('prospects', 'services','sousservices'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
 

     public function store(Request $request)
     {
         // Validation des données
         $validatedData = $request->validate([
             'date_rv' => 'required|date',
             'heure_rv' => 'required',
             'prix_rv' => 'required',
             'prospect_id' => 'required',
             'service_id' => 'required',
             'sousservice_id' => 'nullable', // Making sousservice_id optional
             
             // Ajoutez ici les règles de validation pour les champs personnalisés si nécessaire
         ]);
     
         // Création d'un nouveau rendez-vous
         $rendezvous = new Rendezvous();
         $rendezvous->date_rv = $validatedData['date_rv'];
         $rendezvous->heure_rv= $validatedData['heure_rv'];
         $rendezvous->prix_rv = $validatedData['prix_rv'];
         $rendezvous->prospect_id = $validatedData['prospect_id'];
         $rendezvous->service_id = $validatedData['service_id'];
         $rendezvous->sousservice_id = $validatedData['sousservice_id'];
     
         // Assurez-vous d'ajouter les champs personnalisés si nécessaire
     
         $rendezvous->save();
     
         // Redirection avec un message de succès
         return redirect()->route('rendezvous.index')->with('success', 'Rendez-vous créé avec succès.');
     }
     
    
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $rendezvous = Rendezvous::findOrFail($id);
        $prospects = Prospect::all();
        $services = Service::all();
        $sousservices = Sousservice::all();

        return view('rendezvous.edit', compact('rendezvous', 'prospects', 'services','sousservices'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'date_rv' => 'required|date',
            'heure_rv'=> 'required',
            'prix_rv' => 'required',
            'prospect_id' => 'required',
            'service_id' => 'required',
            'sousservice_id' => 'nullable',
            'statu' => 'nullable',
            // Add validation rules for custom fields if needed
        ]);

        $rendezvous = Rendezvous::findOrFail($id);
        $rendezvous->update($validatedData);

        return redirect()->route('rendezvous.index')->with('success', 'Rendez-vous mis à jour avec succès.');
    }
    public function destroy($id)
    {
        $rendezvous = Rendezvous::findOrFail($id);
        $rendezvous->delete();

        return redirect()->route('rendezvous.index')->with('success', 'Rendez-vous supprimé avec succès.');
    }

    public function updateForFiche(Request $request, $id)
    {
        $validatedData = $request->validate([
            'date_rv' => 'required|date',
            'heure_rv'=> 'required',
            'prix_rv' => 'required',
            'prospect_id' => 'required',
            'service_id' => 'required',
            'statu' => 'nullable',
            // Add validation rules for custom fields if needed
        ]);

        $rendezvous = Rendezvous::findOrFail($id);
        $rendezvous->update($validatedData);

        return redirect()->route('fiche_paiements.index', ['prospect_id' => $request->prospect_id])->with('success', 'Rendez-vous mis à jour avec succès.');
    }
    public function updatePrix(Request $request, $id)
{
    $validatedData = $request->validate([
        'prix_rv' => 'required',
    ]);

    $rendezvous = Rendezvous::findOrFail($id);
    $rendezvous->update(['prix_rv' => $request->prix_rv]);

    return redirect()->route()->with('success', 'Prix du rendez-vous mis à jour avec succès.');
}
    public function updateStatus(Request $request, $id)
    {
        $validatedData = $request->validate([
            'statu' => 'nullable',
            'prix_rv' => 'required',
        ]);
    
        // Find the appointment by ID
        $rendezvous = Rendezvous::findOrFail($id);
    
        // Update the status
        $rendezvous->statu = $validatedData['statu'];
        $rendezvous->update(['prix_rv' => $request->prix_rv]);
        $rendezvous->save();
    
        // Redirect back with a success message
        return redirect()->back()->with('success', 'Status updated successfully');
    }
    
    
    
    public function calendarView()
    {
        $services = Service::all();
        $rendezvous = Rendezvous::with('prospect', 'service')->get();

        return view('rendezvous.calendar', compact('services', 'rendezvous'));
    }
 
    public function destroyForFiche(Request $request, $id)
    {
        $rendezvous = Rendezvous::findOrFail($id);
        $rendezvous->delete();

        return redirect()->route('fiche_paiements.index', ['prospect_id' => $request->prospect_id])->with('success', 'Rendez-vous supprimé avec succès.');
    }
    public function chiffreDaffaire()
    {
        // Get all rendezvous with the "Regler" status
        $rendezvous = Rendezvous::where('statu', 'Regler')->get();
    
        // Initialize total variables
        $totalPrixRdv = 0;

        foreach ($rendezvous as $rdv) {
            // Extract numeric part from prix_rv
            $prixRvNumeric = preg_replace('/[^0-9]/', '', $rdv->prix_rv);
        
            // Convert extracted numeric part to integer and add to totalPrixRdv
            $totalPrixRdv += (int) $prixRvNumeric;
        }
        
        $totalServices = $rendezvous->unique('service_id')->count();

        
        
        return view('rendezvous.chiffre_daffaire', compact('rendezvous', 'totalPrixRdv', 'totalServices'));
    }
    public function __construct()
{
    $this->middleware('role:admin')->only(['edit','update','destroy']);
}
    
}
