<?php

namespace App\Http\Controllers;

use App\Models\Service;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    // Affiche la liste des services
public function index()
{
    $services = Service::all();
    return view('service.index', ['services' => $services]);
}

// Affiche le formulaire de création d'un nouveau service
public function create()
{
    return view('service.create');
}

// Enregistre un nouveau service dans la base de données
public function store(Request $request)
{
    // Validation des données
    $validatedData = $request->validate([
        'nom_service' => 'nullable',
        'nom_grandservice' => 'nullable',
        'prix_service' => 'nullable',

    ]);

    // Création d'un nouveau service
    $service = new Service();
    $service->nom_service = $request->nom_service;
    $service->nom_grandservice = $request->nom_grandservice;
    $service->prix_service = $request->prix_service;

    $service->save();

    return redirect()->route('services.index')->with('success', 'Service ajouté avec succès');
}

// Affiche les détails d'un service spécifique
public function show($id)
{
    $service = Service::findOrFail($id);
    return view('service.show', ['service' => $service]);
}

// Affiche le formulaire de modification d'un service
public function edit($id)
{
    $service = Service::findOrFail($id);
    return view('service.edit', ['service' => $service]);
}

// Met à jour les informations d'un service dans la base de données
public function update(Request $request, $id)
{
    // Validation des données
    $validatedData = $request->validate([
        'nom_service' => 'nullable',
        'nom_grandservice' => 'nullable',
        'prix_service' => 'nullable',    
    ]);

    // Recherche du service à mettre à jour
    $service = Service::findOrFail($id);

    // Mise à jour des informations du service
    $service->nom_service = $request->nom_service;
    $service->nom_grandservice = $request->nom_grandservice;

    $service->prix_service = $request->prix_service;

    $service->save();

    return redirect()->route('services.index')->with('success', 'Service mis à jour avec succès');
}
public function destroy($id)
{
    $service = Service::findOrFail($id);
    $service->delete();
    return redirect()->route('services.index')->with('success', 'Service supprimé avec succès');
}
public function __construct()
{
    $this->middleware('role:admin')->only(['edit','update','destroy']);
}
}
