<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Service;
use App\Models\Sousservice;


class SousserviceController extends Controller
{

   
    public function index(Request $request)
{
    $service_id = $request->input('service_id');
    $sousServices = Sousservice::where('service_id', $service_id)->get();
    return view('sousservice.index', ['sousServices' => $sousServices]);
}

        // Affiche le formulaire de création d'un nouveau sous-service
        public function create()
        {
            $services = Service::all(); // Récupérer tous les services pour le menu déroulant
            return view('sousservice.create', compact('services'));
        }
        public function store(Request $request)
        {
            // Validation des données
            $validatedData = $request->validate([
                'nom_sousservice' => 'required',
                'prix_sousservice' => 'required',
                'service_id' => 'required|exists:services,id', // Assurez-vous que le service_id existe dans la table services
            ]);
    
            // Création d'un nouveau sous-service
            $sousService = new SousService();
            $sousService->nom_sousservice = $request->nom_sousservice;
            $sousService->prix_sousservice = $request->prix_sousservice;
            $sousService->service_id = $request->service_id;
            $sousService->save();
    
            return redirect()->route('sousservices.index',['service_id' => $request->service_id])->with('success', 'Sous-service ajouté avec succès');
        }
            // Affiche les détails d'un sous-service spécifique
    public function show($id)
    {
        $sousService = Sousservice::findOrFail($id);
        return view('sousservice.show', ['sousService' => $sousService]);
    }

    // Affiche le formulaire de modification d'un sous-service
    public function edit($id)
    {
        $sousService = Sousservice::findOrFail($id);
        $services = Service::all(); // Récupérer tous les services pour le menu déroulant
        return view('sousservice.edit', ['sousService' => $sousService, 'services' => $services]);
    }

    // Met à jour les informations d'un sous-service dans la base de données
    

    public function update(Request $request, $id)
{
        


    // Validation des données
    $validatedData = $request->validate([
        'nom_sousservice' => 'required',
        'prix_sousservice' => 'required',
    ]);

    // Recherche du sous-service à mettre à jour
    $sousService = Sousservice::findOrFail($id);

    // Mise à jour des informations du sous-service
    $sousService->nom_sousservice = $request->nom_sousservice;
    $sousService->prix_sousservice = $request->prix_sousservice;
    $sousService->save();

    return redirect()->route('sousservices.index',['service_id' => $request->service_id])->with('success', 'Sous-service mis à jour avec succès');
}

    // Supprime un sous-service de la base de données
    public function destroy( Request $request ,$id)
    {
        $sousService = Sousservice::findOrFail($id);
        $sousService->delete();
        return redirect()->route('sousservices.index',['service_id' => $request->service_id])->with('success', 'Sous-service supprimé avec succès');
    }
    public function __construct()
{
    $this->middleware('role:admin')->only(['edit','update','destroy']);
}

    
    
}
