<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Prospect extends Model
{
    protected $fillable = ['telephone', 'nom', 'prenom', 'date_naissance', 'adresse','email', 'custom_field_1', 'custom_field_2', 'custom_field_3', 'custom_field_4', 'custom_field_5'];
    public function ficheclients()
    {
        return $this->hasMany(FicheClient::class);
    }
    public function fichepaiements()
    {
        return $this->hasMany(FichePaiement::class);
    }
    public function rendezvouss()
    {
        return $this->hasMany(Rendezvous::class);
    }
    public function commentairesMiniceur()
    {
        return $this->hasMany(CommentaireMiniceur::class);
    }
    public function commantaireEpilations()
    {
        return $this->hasMany(CommantaireEpilation::class);
    }
}
