<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Prospect;
use App\Models\Service;
use App\Models\Sousservice;



class Rendezvous extends Model
{
    use HasFactory;
    protected $fillable = [
        'date_rv',
        'time_rv',
        'heure_rv',
        'prix_rv',
        'statu',
        'prospect_id', 
        'service_id',
        'sousservice_id',
        'custom_field_1',
        'custom_field_2',
        'custom_field_3',
        'custom_field_4',
        'custom_field_5',
        'custom_field_6',
        'custom_field_7',
        'custom_field_8',
        'custom_field_9',
        'custom_field_10',
        ];

        public function prospect()
        {
            return $this->belongsTo(Prospect::class);
        } 
        public function service()
        {
            return $this->belongsTo(Service::class);
        }
        public function sousservice()
        {
            return $this->belongsTo(Sousservice::class);
        }
}
