<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRendezvousesIdForeignKeyToFichePaiementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('fiche_paiements', function (Blueprint $table) {
            $table->unsignedBigInteger('rendezvouses_id');
            $table->foreign('rendezvouses_id')->references('id')->on('rendezvouses')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('fiche_paiements', function (Blueprint $table) {
            $table->dropForeign(['rendezvouses_id']);
            $table->dropColumn('rendezvouses_id');
        });
    }
}
