@extends('layouts.app')

@section('content')
<main>
    <div class="container-fluid">
        <h1 class="heading">Fiches des paiements</h1>

        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Prestation</th>
                        <th>Paiement</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($rendezvous as $appointment)
                    <tr>
                        <td>{{ $appointment->date_rv }}</td>
                        <td>{{ $appointment->service->nom_service }}</td>
                        <td>{{ $appointment->prix_rv }}</td>
                        <td>
                        @if(auth()->user() && auth()->user()->isAdmin())
                            <a class="btn btn-primary" href="#" data-toggle="modal" data-target="#editModal{{ $appointment->id }}"><i class="fas fa-edit"></i> Modifier</a>
                            <form action="{{ route('rendezvous.destroyForFiche', $appointment->id) }}" method="POST" style="display: inline-block;">
                                @csrf
                                @method('DELETE')
                                <input type="hidden" name="prospect_id" value="{{ $appointment->prospect_id }}">
                                <button type="submit" class="btn btn-danger" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce rendez-vous?')"><i class="fas fa-trash-alt"></i> Supprimer</button>
                            </form>
                        @endif    
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Edit Modals -->
    @foreach($rendezvous as $rv)
    <div class="modal fade" id="editModal{{ $rv->id }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel{{ $rv->id }}" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="editModalLabel{{ $rv->id }}">Modifier les Détails du Rendez-vous</h5>
                </div>
                <div class="modal-body">
                    <!-- Form for editing rendez-vous details -->
                    <form action="{{ route('rendezvous.updateForFiche', $rv->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="form-group">
                            <label for="date_rv">Date du rendez-vous</label>
                            <input type="date" class="form-control" id="date_rv" name="date_rv" value="{{ $rv->date_rv }}">
                        </div>
                        <div class="form-group">
                            <label for="heure_rv">Heure du rendez-vous</label>
                            <input type="time" class="form-control" id="heure_rv" name="heure_rv" value="{{ $rv->heure_rv }}">
                        </div>
                        <div class="form-group">
                            <label for="prix_rv">Prix du rendez-vous</label>
                            <input type="text" class="form-control" id="prix_rv" name="prix_rv" value="{{ $rv->prix_rv }}">
                        </div>
                        <div class="form-group">
                            <label for="prospect_id{{ $rv->id }}">Prospect</label>
                            <select class="form-control" id="prospect_id{{ $rv->id }}" name="prospect_id">
                                @foreach($prospects as $prospect)
                                <option value="{{ $prospect->id }}" {{ $rv->prospect_id == $prospect->id ? 'selected' : '' }}>{{ $prospect->nom }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="service_id{{ $rv->id }}">Service</label>
                            <select class="form-control" id="service_id{{ $rv->id }}" name="service_id">
                                @foreach($services as $service)
                                <option value="{{ $service->id }}" {{ $rv->service_id == $service->id ? 'selected' : '' }}>{{ $service->nom_service }}</option>
                                @endforeach
                            </select>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
                </div>
                </form>
            </div>
        </div>
    </div>
    @endforeach

    <script>
        function confirmDelete(id) {
            if (confirm('Are you sure you want to delete this record?')) {
                document.getElementById('deleteForm' + id).submit();
            }
        }
    </script>
</main>
@endsection
