@extends('layouts.app')
@section('content')
    <div class="container-fluid">
    
        <a href="{{ route('fiche_clients.index', ['prospect_id' => $prospect->id]) }}" class="btn btn-success">Fiche Epilation</a>
        <a href="{{ route('ficheminiceurs.index', ['prospect_id' => $prospect->id]) }}" class="btn btn-success">Fiche Miniceur</a>
                                         
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>nom</th>
                                    <th>prenom</th>
                                    <th>Date de Naissance</th>
                                    <th>Numéro de Téléphone</th>
                                    <th>Adresse</th>
                                    <th>Email</th>
                                    <!-- Add column headers for other prospect fields if needed -->
                                </tr>
                            </thead>
                            <tbody>
                                    <tr>
                                        <td>{{ $prospect->nom }}</td>
                                        <td>{{ $prospect->prenom }}</td>
                                        <td>{{ $prospect->date_naissance }}</td>
                                        <td>{{ $prospect->telephone }}</td>
                                        <td>{{ $prospect->adresse }}</td>
                                        <td>{{ $prospect->email }}</td>

                                    </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <br> <!-- Add some space between the two tables -->
            </div>
        </div>
    </div>





    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">Fiche Miniceur Du CLient </div>
                    <div class="card-body">
                    <div class="mb-3">
                         <button type="button" class="btn btn-success" data-toggle="modal" data-target="#createModal">Ajouter des nouveaux  détailles </button>
                    </div>

                    <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="createModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createModalLabel">Créer un Fiche Miniceur Du CLient</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Add your form for creating a new Fiche Miniceur here -->
                <form action="{{ route('ficheminiceurs.store') }}" method="POST">
                    @csrf
                    <!-- Add form fields for Fiche Miniceur attributes -->
                        <input type="hidden" name="prospect_id" value="{{ $prospect->id }}">
                    <div class="form-group">
                        <label for="date">Date:</label>
                        <input type="date" name="date" id="date" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="prestation">Prestation:</label>
                        <input type="text" name="prestation" id="prestation" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="vente_1">Vente 1:</label>
                        <input type="number" name="vente_1" id="vente_1" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="vente_2">Vente 2:</label>
                        <input type="number" name="vente_2" id="vente_2" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="vente_3">Vente 3:</label>
                        <input type="number" name="vente_3" id="vente_3" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="cuise_1">Cuise 1:</label>
                        <input type="text" name="cuise_1" id="cuise_1" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="cuise_2">Cuise 2:</label>
                        <input type="text" name="cuise_2" id="cuise_2" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="cuise_3">Cuise 3:</label>
                        <input type="text" name="cuise_3" id="cuise_3" class="form-control" required>
                    </div>
                    <!-- Add other fields -->
                    <button type="submit" class="btn btn-primary">Enregistrer    </button>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewModalLabel">View Fiche Miniceur</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                @foreach($ficheminiceurs as $ficheminiceur)
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>ID:</strong> {{ $ficheminiceur->id }}</p>
                        <p><strong>Date:</strong> {{ $ficheminiceur->date }}</p>
                        <p><strong>Prestation:</strong> {{ $ficheminiceur->prestation }}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Vente:</strong></p>
                        <div class="vente-container">
                            <p>{{ $ficheminiceur->vente_1 }}</p>
                            <p>{{ $ficheminiceur->vente_2 }}</p>
                            <p>{{ $ficheminiceur->vente_3 }}</p>
                        </div>
                        <p><strong>Cuise:</strong></p>
                        <div class="cuise-container">
                            <p>{{ $ficheminiceur->cuise_1 }}</p>
                            <hr class="separator">
                            <p>{{ $ficheminiceur->cuise_2 }}</p>
                            <hr class="separator">
                            <p>{{ $ficheminiceur->cuise_3 }}</p>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>

@foreach($ficheminiceurs as $ficheminiceur)
    <div class="modal fade" id="editModal{{$ficheminiceur->id}}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel{{$ficheminiceur->id}}" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel{{$ficheminiceur->id}}">Edit Fiche Miniceur</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="editForm{{$ficheminiceur->id}}" action="{{ route('ficheminiceurs.update', ['ficheminiceur' => $ficheminiceur->id]) }}" method="POST">
                        @csrf
                        @method('PUT') <!-- Use PUT method for update -->
                        <div class="form-group">
                            <label for="edit_date{{$ficheminiceur->id}}">Date:</label>
                            <input type="date" name="date" id="edit_date{{$ficheminiceur->id}}" class="form-control" value="{{$ficheminiceur->date}}" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_prestation{{$ficheminiceur->id}}">Prestation:</label>
                            <input type="text" name="prestation" id="edit_prestation{{$ficheminiceur->id}}" class="form-control" value="{{$ficheminiceur->prestation}}" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_vente_1{{$ficheminiceur->id}}">Vente 1:</label>
                            <input type="number" name="vente_1" id="edit_vente_1{{$ficheminiceur->id}}" class="form-control" value="{{$ficheminiceur->vente_1}}" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_vente_2{{$ficheminiceur->id}}">Vente 2:</label>
                            <input type="number" name="vente_2" id="edit_vente_2{{$ficheminiceur->id}}" class="form-control" value="{{$ficheminiceur->vente_2}}" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_vente_3{{$ficheminiceur->id}}">Vente 3:</label>
                            <input type="number" name="vente_3" id="edit_vente_3{{$ficheminiceur->id}}" class="form-control" value="{{$ficheminiceur->vente_3}}" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_cuise_1{{$ficheminiceur->id}}">Cuise 1:</label>
                            <input type="text" name="cuise_1" id="edit_cuise_1{{$ficheminiceur->id}}" class="form-control" value="{{$ficheminiceur->cuise_1}}" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_cuise_2{{$ficheminiceur->id}}">Cuise 2:</label>
                            <input type="text" name="cuise_2" id="edit_cuise_2{{$ficheminiceur->id}}" class="form-control" value="{{$ficheminiceur->cuise_2}}" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_cuise_3{{$ficheminiceur->id}}">Cuise 3:</label>
                            <input type="text" name="cuise_3" id="edit_cuise_3{{$ficheminiceur->id}}" class="form-control" value="{{$ficheminiceur->cuise_3}}" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endforeach

                    
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Prestation</th>
                                    <th>Vente</th>
                                    <th>Cuise</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($ficheminiceurs as $ficheminiceur)
                                    <tr>
                                        <td>{{ $ficheminiceur->date }}</td>
                                        <td>{{ $ficheminiceur->prestation }}</td>
                                        <td>
                                            <div class="vente-container">
                                                <div class="vente">{{ $ficheminiceur->vente_1 }}</div>
                                                <div class="vente">{{ $ficheminiceur->vente_2 }}</div>
                                                <div class="vente">{{ $ficheminiceur->vente_3 }}</div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="cuise-container">
                                                <div class="cuise">{{ $ficheminiceur->cuise_1 }}</div>
                                                <div class="cuise">{{ $ficheminiceur->cuise_2 }}</div>
                                                <div class="cuise">{{ $ficheminiceur->cuise_3 }}</div>
                                            </div>
                                        </td>
                                        <!-- Add cells for custom fields -->
                                        <td>
                                        <!-- <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#viewModal">
                                            View
                                        </button> -->
                                        @if(auth()->user() && auth()->user()->isAdmin())
                                            <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#editModal{{$ficheminiceur->id}}">
                                                Modifier 
                                            </button>                                            
                                            <form action="{{ route('ficheminiceurs.destroy', $ficheminiceur->id) }}" method="POST" style="display: inline-block;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this Fiche Miniceur?')">Supprimer</button>
                                            </form>
                                        @endif    
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">Add Comment</div>
                <div class="card-body">
                    <form action="{{ route('commentaire_miniceurs.store', ['prospect_id' => $prospect->id]) }}" method="POST">
                            @csrf
                            <!-- Hidden input field to pass the prospect_id -->

                            <input type="hidden" name="prospect_id" value="{{ $prospect->id }}">

                            <div class="form-group">
                                <label for="commentaireMiniceur">Comment :</label>
                                <textarea name="commentaireMiniceur" id="commentaireMiniceur" class="form-control" rows="3" required></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary">Add Comment</button>
                        </form>
                        <hr> <!-- Optional: Add a horizontal line to separate the forms -->
                </div>
            </div>
        </div>
    </div>
</div>

    <!-- Display Comments Section -->
    <div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">Comments</div>
                <div class="card-body">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Comment</th>

                                <!-- Add column headers for any other attributes of the CommentaireMiniceur model -->
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($comments as $comment)
                                <tr>
                                    <td>{{ $comment->commentairMn }}</td>
                                    <td>
                                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#editCommentModal{{$comment->id}}">
    Edit
</button>
                                      <form action="{{ route('commentaire_miniceurs.destroy', $comment->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this comment?')">Delete</button>
                                        </form>
                                    </td>
                                    <!-- Add cells for any other attributes of the CommentaireMiniceur model -->
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@foreach ($commantaires as $comment)
<div class="modal fade" id="editCommentModal{{$comment->id}}" tabindex="-1" role="dialog" aria-labelledby="editCommentModalLabel{{$comment->id}}" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editCommentModalLabel{{$comment->id}}">Edit Commentaire Miniceur</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Form for editing CommentaireMiniceur -->
                <form action="{{ route('commentaire_miniceurs.update', $comment->id) }}" method="POST">
                    @csrf
                    @method('PUT') <!-- Use PUT method for update -->
                    <div class="form-group">
                        <label for="commentaireMiniceur">Comment</label>
                        <input type="text" name="commentaireMiniceur" id="commentaireMiniceur" class="form-control" value="{{ $comment->commentairMn }}">
                    </div>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </form>
            </div>
        </div>
    </div>
</div>

@endforeach
    <style>
        .vente-container,
        .cuise-container {
            display: flex;
        }

        .vente,
        .cuise {
            border: 1px solid #ccc;
            padding: 5px;
            margin-right: 5px;
        }
    </style>
@endsection
