@extends('layouts.app')
@section('content')
<main class="container mt-5">
    <div class="row">
        <div class="col-md-8">
            <h3>Liste des prospects</h3>
        </div>
        <div class="col-md-4 text-right">
            <a href="{{ route('prospects.create') }}" class="btn btn-primary">Ajouter un prospect</a>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-12">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Prénom</th>
                        <th>Numéro de téléphone</th>
                        <th>Date de Rendez-vous</th>
                        <th>Fiche</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($prospects as $prospect)
                    <tr>
                        <td>{{ $prospect->nom }}</td>
                        <td>{{ $prospect->prenom }}</td>
                        <td>{{ $prospect->telephone }}</td>
                        <td>
                            @if($rendezvous[$prospect->id]->isNotEmpty())
                                {{ $rendezvous[$prospect->id]->last()->date_rv }}
                            @endif
                        </td>
                        <td>
                            <a class="btn btn-sm btn-custom-primary" href="{{ route('fiche_clients.index', ['prospect_id' => $prospect->id]) }}"><i class="fas fa-edit"></i> Fiche de Client</a>
                            <a class="btn btn-sm btn-custom-primary" href="{{ route('fiche_paiements.index', ['prospect_id' => $prospect->id]) }}"><i class="fas fa-edit"></i> Fiche de Paiement</a>
                        </td>
                        <td>
                        <a class="btn btn-sm btn-info" href="#" data-toggle="modal" data-target="#viewModal{{ $prospect->id }}"><i class="fas fa-eye"></i> Consulter</a>
                        @if(auth()->user() && auth()->user()->isAdmin())
    <a class="btn btn-sm btn-primary" href="#" data-toggle="modal" data-target="#editModal{{ $prospect->id }}"><i class="fas fa-edit"></i> Modifier</a>
    <form action="{{ route('prospects.destroy', $prospect->id) }}" method="POST" style="display: inline;">
        @csrf
        @method('DELETE')
        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce prospect?')"><i class="fas fa-trash-alt"></i> Supprimer</button>
    </form>
@endif

                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</main>

@foreach($prospects as $prospect)
<div class="modal fade" id="viewModal{{ $prospect->id }}" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel{{ $prospect->id }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="viewModalLabel{{ $prospect->id }}">Détails du Prospect</h5>
            </div>
            <div class="modal-body">
                <!-- Affichez les détails du prospect ici -->
                <p><strong>Nom:</strong> {{ $prospect->nom }}</p>
                <p><strong>Prénom:</strong> {{ $prospect->prenom }}</p>
                <p><strong>Numéro de téléphone:</strong> {{ $prospect->telephone }}</p>
                <p><strong>Adresse:</strong> {{ $prospect->adresse }}</p>
                <p><strong>email:</strong> {{ $prospect->email }}</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">Fermer</button>
            </div>
        </div>
    </div>
</div>
@endforeach

@foreach($prospects as $prospect)
<div class="modal fade" id="editModal{{ $prospect->id }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel{{ $prospect->id }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="editModalLabel{{ $prospect->id }}">Modifier les Détails du Prospect</h5>
            </div>
            <div class="modal-body">
                <!-- Form for editing prospect details -->
                <form action="{{ route('prospects.update', $prospect->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="form-group">
                        <label for="telephone">Numéro de téléphone</label>
                        <input type="text" class="form-control" id="telephone" name="telephone" value="{{ $prospect->telephone }}">
                    </div>
                    <div class="form-group">
                        <label for="nom">Nom</label>
                        <input type="text" class="form-control" id="nom" name="nom" value="{{ $prospect->nom }}">
                    </div>
                    <div class="form-group">
                        <label for="prenom">Prénom</label>
                        <input type="text" class="form-control" id="prenom" name="prenom" value="{{ $prospect->prenom }}">
                    </div>
                    <div class="form-group">
                        <label for="date_naissance">Date de naissance</label>
                        <input type="date" class="form-control" id="date_naissance" name="date_naissance" value="{{ $prospect->date_naissance }}">
                    </div>
                    <div class="form-group">
                        <label for="adresse">Adresse</label>
                        <textarea class="form-control" id="adresse" name="adresse" rows="3">{{ $prospect->adresse }}</textarea>
                    </div>
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" class="form-control" id="email" name="email" value="{{ $prospect->email }}">
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
            </div>
            </form>
        </div>
    </div>
</div>
@endforeach

@endsection
