@extends('layouts.app')

@section('content')
<main class="container">
    <div class="row">
        <div class="col-md-10 offset-md-1">
            <div class="card">
                <div class="card-header">Chiffre d'Affaire</div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="filter_date" class="form-label">Filter by Date:</label>
                        <input type="date" class="form-control" id="filter_date">
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered" id="rdv_table">
                            <thead>
                                <tr>
                                    <th>Date Rendez-vous</th>
                                    <th>Prestation</th>
                                    <th>Prix Rendez-vous</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($rendezvous as $rdv)
                                <tr data-date="{{ $rdv->date_rv }}">
                                    <td>{{ $rdv->date_rv }}</td>
                                    <td>{{ $rdv->service->nom_service }} {{ $rdv->service->nom_grandservice }}</td>
                                    <td>{{ $rdv->prix_rv }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="2">Total Service:</td>
                                    <td colspan="2" id="total_service"></td>
                                </tr>
                                <tr>
                                    <td colspan="2">Total Prix Rendez-vous:</td>
                                    <td colspan="2" id="total_prix_rv"></td>
                                </tr>
                                <tr>
                                    <td colspan="4">
                                        <button id="export_button" class="btn btn-primary">Export to Excel</button>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.0/xlsx.full.min.js"></script>
<script>
    $(document).ready(function() {
        // Initially, show today's rendezvous
        var today = new Date().toISOString().split('T')[0];
        filterRendezvous(today);

        $('#filter_date').on('change', function() {
            var selectedDate = $(this).val();
            filterRendezvous(selectedDate);
        });

        function filterRendezvous(selectedDate) {
            var totalPrixRv = 0;
            var totalService = 0;
            // Hide all rows initially
            $('tbody tr').hide();
            // Show only the rows for the selected date and calculate total prix_rv and total service
            $('tbody tr[data-date="' + selectedDate + '"]').each(function() {
                $(this).show();
                totalPrixRv += parseFloat($(this).find('td:eq(2)').text());
                totalService++;
            });
            // Update the total prix_rv and total service at the bottom of the table
            $('#total_service').text(totalService);
            $('#total_prix_rv').text(totalPrixRv.toFixed(2));
        }

        // Export to Excel functionality
        $('#export_button').on('click', function() {
    // Clone the table to prevent modifying the original table
    var tableClone = $('#rdv_table').clone();

    // Remove the export button row from the cloned table
    tableClone.find('tfoot tr:last').remove();

    // Convert the modified table to Excel
    var wb = XLSX.utils.table_to_book(tableClone[0], { sheet: "Rendezvous" });
    var wbout = XLSX.write(wb, { bookType: 'xlsx', bookSST: true, type: 'binary' });

    function s2ab(s) {
        var buf = new ArrayBuffer(s.length);
        var view = new Uint8Array(buf);
        for (var i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
        return buf;
    }

    // Create a Blob from the Excel data
    var blob = new Blob([s2ab(wbout)], { type: "application/octet-stream" });

    // Create a download link and trigger the download
    var link = document.createElement('a');
    link.href = window.URL.createObjectURL(blob);
    link.download = 'rendezvous.xlsx';
    link.click();
});

    });
</script>

@endsection
