@extends('layouts.app')

@section('content')
<main class="container mt-5">
    <div class="row">
        <div class="col-md-8">
            <h3>Liste des rendez-vous</h3>
        </div>
        <div class="col-md-4 mt-3 mt-md-0 text-md-right">
            <a href="{{ route('rendezvous.create') }}" class="btn btn-primary">Ajouter un rendez-vous</a>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Date du rendez-vous</th>
                            <th>Prix du rendez-vous</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($rendezvous as $rv)
                        <tr>
                            <td>{{ $rv->date_rv }}</td>
                            <td>{{ $rv->prix_rv }}</td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-sm btn-outline-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        Actions
                                    </button>
                                    <div class="dropdown-menu">
                                    @if(auth()->user() && auth()->user()->isAdmin())
                                        <a class="dropdown-item view-details" href="#" data-toggle="modal" data-target="#editModal{{ $rv->id }}"><i class="fas fa-edit"></i> Modifier</a>
                                        <form action="{{ route('rendezvous.destroy', $rv->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="dropdown-item" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce rendez-vous?')"><i class="fas fa-trash-alt"></i> Supprimer</button>
                                        </form>
                                    @endif
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

@foreach($rendezvous as $rv)
<div class="modal fade" id="editModal{{ $rv->id }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel{{ $rv->id }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="editModalLabel{{ $rv->id }}">Modifier les Détails du Rendez-vous</h5>
            </div>
            <div class="modal-body">
                <!-- Form for editing rendez-vous details -->
                <form action="{{ route('rendezvous.update', $rv->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="form-group">
                        <label for="date_rv">Date du rendez-vous</label>
                        <input type="date" class="form-control" id="date_rv" name="date_rv" value="{{ $rv->date_rv }}">
                    </div>
                    <div class="form-group">
                        <label for="heure_rv">Heure du rendez-vous</label>
                        <input type="time" class="form-control" id="heure_rv" name="heure_rv" value="{{ $rv->heure_rv }}">
                    </div>
                    <div class="form-group">
                        <label for="prix_rv">Prix du rendez-vous</label>
                        <input type="text" class="form-control" id="prix_rv" name="prix_rv" value="{{ $rv->prix_rv }}">
                    </div>
                    <div class="form-group">
                        <label for="prospect_id{{ $rv->id }}">Prospect</label>
                        <select class="form-control" id="prospect_id{{ $rv->id }}" name="prospect_id">
                            @foreach($prospects as $prospect)
                                <option value="{{ $prospect->id }}" {{ $rv->prospect_id == $prospect->id ? 'selected' : '' }}>{{ $prospect->nom }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="service_id{{ $rv->id }}">Service</label>
                        <select class="form-control" id="service_id{{ $rv->id }}" name="service_id">
                            @foreach($services as $service)
                                @if($service->nom_service !== null)
                                    <option value="{{ $service->id }}" {{ $rv->service_id == $service->id ? 'selected' : '' }}>{{ $service->nom_service }}</option>
                                @endif
                            @endforeach
                            @foreach($services as $service)
                                @if($service->nom_grandservice !== null)
                                    <option value="{{ $service->id }}" {{ $rv->service_id == $service->id ? 'selected' : '' }}>{{ $service->nom_grandservice }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
            </div>
            </form>
        </div>
    </div>
</div>
@endforeach

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        var dropdownButtons = document.querySelectorAll('.dropdown-toggle');
        dropdownButtons.forEach(function(button) {
            button.addEventListener('click', function() {
                var dropdownMenu = this.nextElementSibling;
                if (dropdownMenu.classList.contains('show')) {
                    dropdownMenu.classList.remove('show');
                } else {
                    dropdownMenu.classList.add('show');
                }
            });
        });
    });

    document.addEventListener('click', function(event) {
        var dropdownMenus = document.querySelectorAll('.dropdown-menu');
        var dropdownToggles = document.querySelectorAll('.dropdown-toggle');
        var isClickWithinDropdown = false;

        // Check if the click is within any dropdown menu
        dropdownMenus.forEach(function(menu) {
            if (menu.contains(event.target)) {
                isClickWithinDropdown = true;
            }
        });

        // Check if the click is within any dropdown toggle
        dropdownToggles.forEach(function(toggle) {
            if (toggle.contains(event.target)) {
                isClickWithinDropdown = true;
            }
        });

        // If click is not within any dropdown menu or toggle, close all dropdown menus
        if (!isClickWithinDropdown) {
            dropdownMenus.forEach(function(menu) {
                menu.classList.remove('show');
            });
        }
    });

    // Close dropdown menu when clicking on any item within it
    document.querySelectorAll('.dropdown-item').forEach(function(item) {
        item.addEventListener('click', function() {
            var dropdownMenu = this.closest('.dropdown-menu');
            dropdownMenu.classList.remove('show');
        });
    });
</script>  

@endsection
