@extends('layouts.app')

@section('content')

<main class="container mt-5">
    
    <div class="row">
        <div class="col-md-8">
            <h3>Liste des Services</h3>
        </div>
        <div class="col-md-4 text-right">
            <a href="{{ route('services.create') }}" class="btn btn-success">Ajouter un Service</a>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-12">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Services</th>
                        <th>Prix</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($services as $service)
                    <tr>
                        <td>{{ $service->nom_service }} {{ $service->nom_grandservice }}</td>
                        <td>{{ $service->prix_service }}</td>
                        <td>
                            <div class="btn-group">
                            @if(auth()->user() && auth()->user()->isAdmin())

                                <a href="#" class="btn btn-sm btn-warning mr-1" data-toggle="modal" data-target="#editModal{{ $service->id }}"><i class="fas fa-edit"></i> Modifier</a>
                            @endif
                                @if(!empty($service->nom_grandservice))
                                    <a href="{{ route('sousservices.index', ['service_id' => $service->id]) }}" class="btn btn-sm btn-info mr-1"><i class="fas fa-edit"></i> Sous_Service</a>
                                @endif
                                @if(auth()->user() && auth()->user()->isAdmin())

                                <form action="{{ route('services.destroy', $service->id) }}" method="POST">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger mr-1" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce service?')"><i class="fas fa-trash-alt"></i> Supprimer</button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</main>

@foreach($services as $service)
<div class="modal fade" id="editModal{{ $service->id }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel{{ $service->id }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title" id="editModalLabel{{ $service->id }}">
                    @if(!empty($service->nom_service))
                        Modifier les Détails du Service
                    @else
                        Modifier le Nom du Grand Service
                    @endif
                </h5>
            </div>
            <div class="modal-body">
                <!-- Form for editing service details -->
                <form action="{{ route('services.update', $service->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    @if(!empty($service->nom_service))
                    <div class="form-group">
                        <label for="nom_service">Service</label>
                        <input type="text" class="form-control" id="nom_service" name="nom_service" value="{{ $service->nom_service }}">
                    </div>
                    <div class="form-group">
                        <label for="prix_service">Prix</label>
                        <input type="text" class="form-control" id="prix_service" name="prix_service" value="{{ $service->prix_service }}">
                    </div>
                    @else
                    <div class="form-group">
                        <label for="nom_grandservice">Nom du Grand Service</label>
                        <input type="text" class="form-control" id="nom_grandservice" name="nom_grandservice" value="{{ $service->nom_grandservice }}">
                    </div>
                    @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-success">Enregistrer les modifications</button>
            </div>
            </form>
        </div>
    </div>
</div>
@endforeach

@endsection
