@extends('layouts.app')

@section('content')

<main class="col-md-12 content">
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <a href="{{ route('services.index') }}" class="btn btn-dark   ">
                <i class="fas fa-arrow-left"></i> Retour
            </a>
        </div>
    </div>
</div>

    <div class="container">
        <div class="row mt-5">
            <div class="col-md-8">
                <h2>Liste des Sous-Services</h2>
            </div>
            <div class="col-md-4 text-right">
                <a href="{{ route('sousservices.create') }}" class="btn btn-primary"><i class="fas fa-plus-circle"></i> Ajouter un Sous-Service</a>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-12">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Nom</th>
                            <th>Prix</th>
                            <th>Service Parent</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($sousServices as $sousService)
                        <tr>
                            <!-- Contenu du tableau pour chaque sous-service -->
                            <td>{{ $sousService->nom_sousservice }}</td>
                            <td>{{ $sousService->prix_sousservice }}</td>
                            <td>{{ $sousService->service->nom_grandservice }}</td>
                            <td>
                                <!-- Bouton pour ouvrir le modal de modification -->
                                @if(auth()->user() && auth()->user()->isAdmin())

                                <button type="button" class="btn btn-warning btn-sm" data-toggle="modal" data-target="#editModal{{ $sousService->id }}"><i class="fas fa-edit"></i> Modifier</button>
                                @endif
                                <!-- Modal de modification -->

                                <div class="modal fade" id="editModal{{ $sousService->id }}" tabindex="-1" role="dialog" aria-labelledby="editModalLabel{{ $sousService->id }}" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="editModalLabel{{ $sousService->id }}">Modifier le Sous-Service</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                            <!-- Formulaire de modification du sous-service -->
                                            <form action="{{ route('sousservices.update', $sousService->id) }}" method="POST">
                                                @csrf
                                                @method('PUT')
                                                <input type="hidden" name="service_id" value="{{$sousService->service_id}}">
                                                <div class="form-group">
                                                    <label for="nom_sousservice">Nom</label>
                                                    <input type="text" class="form-control" id="nom_sousservice" name="nom_sousservice" value="{{ $sousService->nom_sousservice }}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="prix_sousservice">Prix</label>
                                                    <input type="text" class="form-control" id="prix_sousservice" name="prix_sousservice" value="{{ $sousService->prix_sousservice }}">
                                                </div>
                                                <!-- Vous pouvez ajouter d'autres champs de formulaire pour la modification -->
                                            
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                                                    <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
                                                </div>
                                            </form>
                                        </div>

                                        </div>
                                    </div>
                                </div>
                                @if(auth()->user() && auth()->user()->isAdmin())

                                <form action="{{ route('sousservices.destroy', $sousService->id) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')   
                                    <input type="hidden" name="service_id" value="{{$sousService->service_id}}">
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce sous-service ?')"><i class="fas fa-trash"></i> Supprimer</button>
                                </form>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

@endsection
