<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProspectController;
use App\Http\Controllers\FicheClientController;
use App\Http\Controllers\FicheMiniceurController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\RendezvousController;
use App\Http\Controllers\FichePaimentController;
use App\Http\Controllers\CommentaireMiniceurController;
use App\Http\Controllers\CommantaireEpilationController;
use App\Http\Controllers\SousserviceController;





/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');



// routes pour Prospect 
// Route pour afficher la liste des prospects
Route::get('/prospects', [ProspectController::class, 'index'])->name('prospects.index');

// Route pour afficher le formulaire de création de prospect
Route::get('/prospects/create', [ProspectController::class, 'create'])->name('prospects.create');

// Route pour enregistrer un nouveau prospect
Route::post('/prospects', [ProspectController::class, 'store'])->name('prospects.store');

// Route pour afficher les détails d'un prospect
Route::get('/prospects/{id}', [ProspectController::class, 'show'])->name('prospects.show');

// Route pour afficher le formulaire de modification d'un prospect
// Route::get('/prospects/{id}/edit', [ProspectController::class, 'edit'])->name('prospects.edit');

// Route pour mettre à jour un prospect
Route::put('/prospects/{id}', [ProspectController::class, 'update'])->name('prospects.update');

// Route pour supprimer un prospect
Route::delete('/prospects/{id}', [ProspectController::class, 'destroy'])->name('prospects.destroy');


/// fiche client 
Route::get('/fiche_clients/{prospect_id}', [FicheClientController::class, 'index'])->name('fiche_clients.index');
Route::get('/fiche_clients/create', [FicheClientController::class, 'create'])->name('fiche_clients.create');
Route::post('/fiche_clients', [FicheClientController::class, 'store'])->name('fiche_clients.store');
Route::get('/fiche_clients/{ficheClient}', [FicheClientController::class, 'show'])->name('fiche_clients.show');
Route::get('/fiche_clients/{ficheClient}/edit', [FicheClientController::class, 'edit'])->name('fiche_clients.edit');
Route::put('/fiche_clients/{ficheClient}', [FicheClientController::class, 'update'])->name('fiche_clients.update');
Route::delete('/fiche_clients/{ficheClient}', [FicheClientController::class, 'destroy'])->name('fiche_clients.destroy');

// fiche miniceur


Route::get('/ficheminiceurs/{prospect_id}', [FicheMiniceurController::class, 'index'])->name('ficheminiceurs.index');
Route::get('/ficheminiceurs/create', [FicheMiniceurController::class, 'create'])->name('ficheminiceurs.create');
Route::post('/ficheminiceurs', [FicheMiniceurController::class, 'store'])->name('ficheminiceurs.store');
Route::get('/ficheminiceurs/{ficheminiceur}', [FicheMiniceurController::class, 'show'])->name('ficheminiceurs.show');
Route::get('/ficheminiceurs/{ficheminiceur}/edit', [FicheMiniceurController::class, 'edit'])->name('ficheminiceurs.edit');
Route::put('/ficheminiceurs/{ficheminiceur}', [FicheMiniceurController::class, 'update'])->name('ficheminiceurs.update');
Route::delete('/ficheminiceurs/{ficheminiceur}', [FicheMiniceurController::class, 'destroy'])->name('ficheminiceurs.destroy');



// routes pour Service 
// Route pour afficher la liste des Services
Route::get('/services', [ServiceController::class, 'index'])->name('services.index');

// Route pour afficher le formulaire de création de Service
Route::get('/services/create', [ServiceController::class, 'create'])->name('services.create');

// Route pour enregistrer un nouveau Service
Route::post('/services', [ServiceController::class, 'store'])->name('services.store');

// Route pour mettre à jour un Service
Route::put('/services/{id}', [ServiceController::class, 'update'])->name('services.update');

// Route pour supprimer un Service
Route::delete('/services/{id}', [ServiceController::class, 'destroy'])->name('services.destroy');

// route pour rendez-vous

Route::get('/rendezvous', [RendezvousController::class, 'index'])->name('rendezvous.index');
Route::get('/rendezvous/create', [RendezvousController::class, 'create'])->name('rendezvous.create');
Route::post('/rendezvous', [RendezvousController::class, 'store'])->name('rendezvous.store');
Route::get('/rendezvous/{id}', [RendezvousController::class, 'show'])->name('rendezvous.show');
Route::get('/rendezvous/{id}/edit', [RendezvousController::class, 'edit'])->name('rendezvous.edit');
Route::put('/rendezvous/{id}', [RendezvousController::class, 'update'])->name('rendezvous.update');
Route::put('/rendezvous/{id}/update-for-fiche', [RendezvousController::class, 'updateForFiche'])->name('rendezvous.updateForFiche');
Route::delete('/rendezvous/{id}/delete-for-fiche', [RendezvousController::class, 'destroyForFiche'])->name('rendezvous.destroyForFiche');
Route::delete('/rendezvous/{id}', [RendezvousController::class, 'destroy'])->name('rendezvous.destroy');
Route::post('/rendezvous/{id}/update-prix', [RendezvousController::class, 'updatePrix'])->name('rendezvous.updatePrix');


//route pour fichepaiment 
Route::get('/fiche-paiements', [FichePaimentController::class, 'index'])->name('fiche_paiements.index');
Route::get('/fiche-paiements/create', [FichePaimentController::class, 'create'])->name('fiche_paiements.create');
Route::post('/fiche-paiements', [FichePaimentController::class, 'store'])->name('fiche_paiements.store');
Route::get('/fiche-paiements/{{fichePaiement}', [FichePaimentController::class, 'show'])->name('fiche_paiements.show');
Route::get('/fiche_paiements/{fichePaiement}/edit', 'FichePaimentController@edit')->name('fiche_paiements.edit');
Route::put('/fiche-paiements/{fichePaiement}', [FichePaimentController::class, 'update'])->name('fiche_paiements.update');
Route::delete('/fiche-paiements/{fichePaiement}', [FichePaimentController::class, 'destroy'])->name('fiche_paiements.destroy');

// commentaire miniceur 
Route::post('/commentaire_miniceurs/{prospect_id}', [CommentaireMiniceurController::class, 'store'])->name('commentaire_miniceurs.store');
Route::get('/commentaire_miniceurs/{commentaireMiniceur}/edit', [CommentaireMiniceurController::class, 'edit'])->name('commentaire_miniceurs.edit');
Route::put('/commentaire_miniceurs/{commentaireMiniceur}', [CommentaireMiniceurController::class, 'update'])->name('commentaire_miniceurs.update');
Route::delete('/commentaire_miniceurs/{commentaireMiniceur}', [CommentaireMiniceurController::class, 'destroy'])->name('commentaire_miniceurs.destroy');

//commantaire epilation
Route::post('/commantaire_epilations/{prospect_id}', [CommantaireEpilationController::class, 'store'])->name('commantaire_epilations.store');
Route::get('/commantaire_epilations/{commantaireEpilation}/edit', [CommantaireEpilationController::class, 'edit'])->name('commantaire_epilations.edit');
Route::put('/commantaire_epilations/{commantaireEpilation}', [CommantaireEpilationController::class, 'update'])->name('commantaire_epilations.update');
Route::delete('/commantaire_epilations/{commantaireEpilation}', [CommantaireEpilationController::class, 'destroy'])->name('commantaire_epilations.destroy');

Route::post('/update-status/{id}', [RendezvousController::class, 'updateStatus'])->name('update.status');
Route::get('/calendar', [RendezvousController::class, 'calendarView'])->name('calendar');
// routes/web.php

Route::get('/chiffre-daffaire', [RendezvousController::class, 'chiffreDaffaire'])->name('rendezvous.chiffre_daffaire');
// routees pour sousservice 

Route::get('/sousservices', [SousserviceController::class, 'index'])->name('sousservices.index');
Route::get('/sousservices/create', [SousserviceController::class, 'create'])->name('sousservices.create');
Route::post('/sousservices', [SousserviceController::class, 'store'])->name('sousservices.store');
Route::get('/sousservices/{id}', [SousserviceController::class, 'show'])->name('sousservices.show');
Route::get('/sousservices/{id}/edit', [SousserviceController::class, 'edit'])->name('sousservices.edit');
Route::put('/sousservices/{id}', [SousserviceController::class, 'update'])->name('sousservices.update');
Route::delete('/sousservices/{id}', [SousserviceController::class, 'destroy'])->name('sousservices.destroy');