<!-- resources/views/fiche_clients/index.blade.php -->



<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">Prospect Data</div>
                    <div class="card-body">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>nom</th>
                                    <th>prenom</th>
                                    <th>Date de Naissance</th>
                                    <th>Numéro de Téléphone</th>
                                    <th>Actions</th>
                                    <!-- Add column headers for other prospect fields if needed -->
                                </tr>
                            </thead>
                            <tbody>
                                    <tr>
                                        <td><?php echo e($prospect->nom); ?></td>
                                        <td><?php echo e($prospect->prenom); ?></td>
                                        <td><?php echo e($prospect->date_naissance); ?></td>
                                        <td><?php echo e($prospect->adresse); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('fiche_clients.index', ['prospect_id' => $prospect->id])); ?>" class="btn btn-success">Fiche Epilation</a>
                                                <a href="<?php echo e(route('ficheminiceurs.index', ['prospect_id' => $prospect->id])); ?>" class="btn btn-success">Fiche Miniceur</a>
                                         </td>
                                        <!-- Add cells for other prospect fields if needed -->
                                    </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <br> <!-- Add some space between the two tables -->
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">Fiche Clients</div>

                    <div class="card-body">
                        <!-- Button trigger modal -->
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#createModal">
                            Create New Fiche Client
                        </button>

                 <!-- Create Modal -->
<!-- Create Modal -->
<div class="modal fade" id="createModal" tabindex="-1" aria-labelledby="createModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createModalLabel">Create New Fiche Client</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('fiche_clients.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <!-- Add form fields for creating a new Fiche Client here -->
                    <!-- Hidden input field to pass the prospect_id -->
                    <input type="hidden" name="prospect_id" value="<?php echo e($prospect->id); ?>">
                    <div class="mb-3">
                        <label for="date" class="form-label">Date</label>
                        <input type="date" class="form-control" id="date" name="date" required>
                    </div>
                    <div class="mb-3">
                        <label for="parametre" class="form-label">Parametre</label>
                        <input type="text" class="form-control" id="parametre" name="parametre" required>
                    </div>
                    <div class="mb-3">

                    </div>
                    <!-- Add fields for other attributes as needed -->
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>


                   <!-- View Modal -->
                   <?php $__currentLoopData = $ficheClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ficheClient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                   <!-- View Modal -->
<div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewModalLabel">View Fiche Client</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Display the details of the Fiche Client here in a table -->
                <table class="table">
                    <tbody>
                        <tr>
                            <th>Date</th>
                            <td><?php echo e($ficheClient->date); ?></td>
                        </tr>
                        <tr>
                            <th>Parametre</th>
                            <td><?php echo e($ficheClient->parametre); ?></td>
                        </tr>
                        <tr>
                            <th>Prospect</th>
                            <td><?php echo e($ficheClient->prospect->nom); ?></td>
                        </tr>
                        <!-- Add rows for other attributes as needed -->
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


                        <!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalLabel">Edit Fiche Client</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('fiche_clients.update', $ficheClient->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <!-- Edit form fields for the Fiche Client here -->
                    <div class="mb-3">
                        <label for="edit_date" class="form-label">Date</label>
                        <input type="date" class="form-control" id="edit_date" name="date" value="<?php echo e($ficheClient->date); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_parametre" class="form-label">Parametre</label>
                        <input type="text" class="form-control" id="edit_parametre" name="parametre" value="<?php echo e($ficheClient->parametre); ?>" required>
                    </div>
                    <!-- Hidden input field for prospect_id -->
                    <input type="hidden" name="prospect_id" value="<?php echo e($ficheClient->prospect_id); ?>">
                    <!-- Add fields for other attributes as needed -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>


<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Parametre</th>
                                    <!-- Add column headers for custom fields here -->
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $ficheClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ficheClient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($ficheClient->id); ?></td>
                                        <td><?php echo e($ficheClient->date); ?></td>
                                        <td><?php echo e($ficheClient->parametre); ?></td>
                                        <!-- Add cells for custom fields here -->
                                        <td>
                                            <button type="button" class="btn btn-info" onclick="viewFicheClient(<?php echo e($ficheClient->id); ?>)">View</button>
                                            <button type="button" class="btn btn-primary" onclick="editFicheClient(<?php echo e($ficheClient->id); ?>)">Edit</button>
                                            <form action="<?php echo e(route('fiche_clients.destroy', $ficheClient->id)); ?>" method="POST" style="display: inline-block;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this Fiche Client?')">Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
    <div class="row">
        <div class="col-md-12">
            <h2>Commentaires</h2>
            <!-- Formulaire pour ajouter un nouveau commantaire -->
            <form action="<?php echo e(route('commantaires.store', ['ficheClient' => $ficheClient, 'prospect_id' => $prospect->id])); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                <?php $__currentLoopData = $ficheCliens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ficheClient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <input type="hidden" name="ficheclient_id" value="<?php echo e($ficheClient->id); ?>">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group">
                    <label for="commantaire_epilation">Votre commentaire :</label>
                    <textarea class="form-control" id="commantaire_epilation" name="commantaire_epilation" rows="3"></textarea>
                </div>
                <button type="submit" class="btn btn-primary">Ajouter un commentaire</button>
            </form>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-md-12">
            <h3>Commentaires existants :</h3>
            <!-- Affichage des commantaires existants -->
            <?php $__currentLoopData = $commantaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commantaire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card mb-3">
                    <div class="card-body">
                        <p><?php echo e($commantaire->commantaire_epilation); ?></p>
                        <!-- Affichez d'autres détails du commantaire si nécessaire -->
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
    <script>
        function viewFicheClient(id) {
            // Use AJAX to fetch the fiche client data and populate the view modal
            $('#viewModal').modal('show');
        }

        function editFicheClient(id) {
            // Use AJAX to fetch the fiche client data and populate the edit modal
            $('#editModal').modal('show');
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\GTO\Desktop\gestionservice\resources\views/fiche_clients/index.blade.php ENDPATH**/ ?>