

<?php $__env->startSection('content'); ?>

<main class="col-md-12 content">
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <a href="<?php echo e(route('services.index')); ?>" class="btn btn-dark   ">
                <i class="fas fa-arrow-left"></i> Retour
            </a>
        </div>
    </div>
</div>

    <div class="container">
        <div class="row mt-5">
            <div class="col-md-8">
                <h2>Liste des Sous-Services</h2>
            </div>
            <div class="col-md-4 text-right">
                <a href="<?php echo e(route('sousservices.create')); ?>" class="btn btn-primary"><i class="fas fa-plus-circle"></i> Ajouter un Sous-Service</a>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-12">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Nom</th>
                            <th>Prix</th>
                            <th>Service Parent</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $sousServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sousService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <!-- Contenu du tableau pour chaque sous-service -->
                            <td><?php echo e($sousService->nom_sousservice); ?></td>
                            <td><?php echo e($sousService->prix_sousservice); ?></td>
                            <td><?php echo e($sousService->service->nom_grandservice); ?></td>
                            <td>
                                <!-- Bouton pour ouvrir le modal de modification -->
                                <?php if(auth()->user() && auth()->user()->isAdmin()): ?>

                                <button type="button" class="btn btn-warning btn-sm" data-toggle="modal" data-target="#editModal<?php echo e($sousService->id); ?>"><i class="fas fa-edit"></i> Modifier</button>
                                <?php endif; ?>
                                <!-- Modal de modification -->

                                <div class="modal fade" id="editModal<?php echo e($sousService->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel<?php echo e($sousService->id); ?>" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="editModalLabel<?php echo e($sousService->id); ?>">Modifier le Sous-Service</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                            <!-- Formulaire de modification du sous-service -->
                                            <form action="<?php echo e(route('sousservices.update', $sousService->id)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <input type="hidden" name="service_id" value="<?php echo e($sousService->service_id); ?>">
                                                <div class="form-group">
                                                    <label for="nom_sousservice">Nom</label>
                                                    <input type="text" class="form-control" id="nom_sousservice" name="nom_sousservice" value="<?php echo e($sousService->nom_sousservice); ?>">
                                                </div>
                                                <div class="form-group">
                                                    <label for="prix_sousservice">Prix</label>
                                                    <input type="text" class="form-control" id="prix_sousservice" name="prix_sousservice" value="<?php echo e($sousService->prix_sousservice); ?>">
                                                </div>
                                                <!-- Vous pouvez ajouter d'autres champs de formulaire pour la modification -->
                                            
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                                                    <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
                                                </div>
                                            </form>
                                        </div>

                                        </div>
                                    </div>
                                </div>
                                <?php if(auth()->user() && auth()->user()->isAdmin()): ?>

                                <form action="<?php echo e(route('sousservices.destroy', $sousService->id)); ?>" method="POST" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>   
                                    <input type="hidden" name="service_id" value="<?php echo e($sousService->service_id); ?>">
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce sous-service ?')"><i class="fas fa-trash"></i> Supprimer</button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lasercli/public_html/app.laserclinic.ma/resources/views/sousservice/index.blade.php ENDPATH**/ ?>