

<?php $__env->startSection('content'); ?>
<main class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Créer un nouveau rendez-vous</div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('rendezvous.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-group row">
                            <label for="date_rv" class="col-md-4 col-form-label text-md-right">Date du rendez-vous:</label>
                            <div class="col-md-6">
                                <input type="date" class="form-control" id="date_rv" name="date_rv" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="heure_rv" class="col-md-4 col-form-label text-md-right">Heure du rendez-vous:</label>
                            <div class="col-md-6">
                                <input type="time" class="form-control" id="heure_rv" name="heure_rv" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="prix_rv" class="col-md-4 col-form-label text-md-right">Prix du rendez-vous:</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" id="prix_rv" name="prix_rv" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="search" class="col-md-4 col-form-label text-md-right">Search:</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" id="search" placeholder="Search for a telephone number...">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="prospect_id" class="col-md-4 col-form-label text-md-right">Prospect:</label>
                            <div class="col-md-6">
                                <select class="form-control" id="prospect_id" name="prospect_id" required>
                                    <?php $__currentLoopData = $prospects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prospect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($prospect->id); ?>"><?php echo e($prospect->nom); ?> - <?php echo e($prospect->telephone); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="service_id" class="col-md-4 col-form-label text-md-right">Nom du Service:</label>
                            <div class="col-md-6">
                                <select class="form-control" id="service_id" name="service_id" required>
                                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($service->nom_service !== null): ?>
                                            <option value="<?php echo e($service->id); ?>"><?php echo e($service->nom_service); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($service->nom_grandservice !== null): ?>
                                            <option value="<?php echo e($service->id); ?>"><?php echo e($service->nom_grandservice); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="sousservice_id" class="col-md-4 col-form-label text-md-right">Sous-Service:</label>
                            <div class="col-md-6">
                                <select class="form-control" id="sousservice_id" name="sousservice_id">
                                    <option value="">Choisir un sous-service</option>
                                    <?php $__currentLoopData = $sousservices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sousservice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($sousservice->id); ?>" data-service="<?php echo e($sousservice->service_id); ?>">
                                            <?php echo e($sousservice->nom_sousservice); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">Créer</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        // Store the original options of the select element
        var originalOptions = $('#prospect_id').html();

        $('#search').on('input', function() {
            var searchText = $(this).val().toLowerCase();

            // Filter options based on telephone number
            var filteredOptions = $(originalOptions).filter(function() {
                return $(this).text().toLowerCase().includes(searchText);
            });

            // Update the select element with filtered options
            $('#prospect_id').html(filteredOptions);

            // Restore original options if search text is empty
            if (searchText === '') {
                $('#prospect_id').html(originalOptions);
            }
        });
    });
    document.getElementById('service_id').addEventListener('change', function() {
        var selectedServiceId = this.value;
        var sousserviceOptions = document.querySelectorAll('#sousservice_id option');

        sousserviceOptions.forEach(function(option) {
            if (option.getAttribute('data-service') === selectedServiceId) {
                option.selected = true;
            } else {
                option.selected = false;
            }
        });
    });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gestionservice\resources\views/rendezvous/create.blade.php ENDPATH**/ ?>