

<?php $__env->startSection('content'); ?>
<main class="container mt-5">
    <div class="row">
        <div class="col-md-8">
            <h3>Liste des rendez-vous</h3>
        </div>
        <div class="col-md-4 mt-3 mt-md-0 text-md-right">
            <a href="<?php echo e(route('rendezvous.create')); ?>" class="btn btn-primary">Ajouter un rendez-vous</a>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Date du rendez-vous</th>
                            <th>Prix du rendez-vous</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $rendezvous; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($rv->date_rv); ?></td>
                            <td><?php echo e($rv->prix_rv); ?></td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-sm btn-outline-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        Actions
                                    </button>
                                    <div class="dropdown-menu">
                                    <?php if(auth()->user() && auth()->user()->isAdmin()): ?>
                                        <a class="dropdown-item view-details" href="#" data-toggle="modal" data-target="#editModal<?php echo e($rv->id); ?>"><i class="fas fa-edit"></i> Modifier</a>
                                        <form action="<?php echo e(route('rendezvous.destroy', $rv->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="dropdown-item" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce rendez-vous?')"><i class="fas fa-trash-alt"></i> Supprimer</button>
                                        </form>
                                    <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<?php $__currentLoopData = $rendezvous; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editModal<?php echo e($rv->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel<?php echo e($rv->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="editModalLabel<?php echo e($rv->id); ?>">Modifier les Détails du Rendez-vous</h5>
            </div>
            <div class="modal-body">
                <!-- Form for editing rendez-vous details -->
                <form action="<?php echo e(route('rendezvous.update', $rv->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="form-group">
                        <label for="date_rv">Date du rendez-vous</label>
                        <input type="date" class="form-control" id="date_rv" name="date_rv" value="<?php echo e($rv->date_rv); ?>">
                    </div>
                    <div class="form-group">
                        <label for="heure_rv">Heure du rendez-vous</label>
                        <input type="time" class="form-control" id="heure_rv" name="heure_rv" value="<?php echo e($rv->heure_rv); ?>">
                    </div>
                    <div class="form-group">
                        <label for="prix_rv">Prix du rendez-vous</label>
                        <input type="text" class="form-control" id="prix_rv" name="prix_rv" value="<?php echo e($rv->prix_rv); ?>">
                    </div>
                    <div class="form-group">
                        <label for="prospect_id<?php echo e($rv->id); ?>">Prospect</label>
                        <select class="form-control" id="prospect_id<?php echo e($rv->id); ?>" name="prospect_id">
                            <?php $__currentLoopData = $prospects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prospect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($prospect->id); ?>" <?php echo e($rv->prospect_id == $prospect->id ? 'selected' : ''); ?>><?php echo e($prospect->nom); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="service_id<?php echo e($rv->id); ?>">Service</label>
                        <select class="form-control" id="service_id<?php echo e($rv->id); ?>" name="service_id">
                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($service->nom_service !== null): ?>
                                    <option value="<?php echo e($service->id); ?>" <?php echo e($rv->service_id == $service->id ? 'selected' : ''); ?>><?php echo e($service->nom_service); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($service->nom_grandservice !== null): ?>
                                    <option value="<?php echo e($service->id); ?>" <?php echo e($rv->service_id == $service->id ? 'selected' : ''); ?>><?php echo e($service->nom_grandservice); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
            </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        var dropdownButtons = document.querySelectorAll('.dropdown-toggle');
        dropdownButtons.forEach(function(button) {
            button.addEventListener('click', function() {
                var dropdownMenu = this.nextElementSibling;
                if (dropdownMenu.classList.contains('show')) {
                    dropdownMenu.classList.remove('show');
                } else {
                    dropdownMenu.classList.add('show');
                }
            });
        });
    });

    document.addEventListener('click', function(event) {
        var dropdownMenus = document.querySelectorAll('.dropdown-menu');
        var dropdownToggles = document.querySelectorAll('.dropdown-toggle');
        var isClickWithinDropdown = false;

        // Check if the click is within any dropdown menu
        dropdownMenus.forEach(function(menu) {
            if (menu.contains(event.target)) {
                isClickWithinDropdown = true;
            }
        });

        // Check if the click is within any dropdown toggle
        dropdownToggles.forEach(function(toggle) {
            if (toggle.contains(event.target)) {
                isClickWithinDropdown = true;
            }
        });

        // If click is not within any dropdown menu or toggle, close all dropdown menus
        if (!isClickWithinDropdown) {
            dropdownMenus.forEach(function(menu) {
                menu.classList.remove('show');
            });
        }
    });

    // Close dropdown menu when clicking on any item within it
    document.querySelectorAll('.dropdown-item').forEach(function(item) {
        item.addEventListener('click', function() {
            var dropdownMenu = this.closest('.dropdown-menu');
            dropdownMenu.classList.remove('show');
        });
    });
</script>  

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lasercli/public_html/app.laserclinic.ma/resources/views/rendezvous/index.blade.php ENDPATH**/ ?>