

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <div class="container">
        <div class="row mb-4">
            <div class="col-md-12 d-flex justify-content-end">
                <a href="<?php echo e(route('fiche_clients.index', ['prospect_id' => $prospect->id])); ?>" class="btn btn-success mr-2">Fiche Epilation</a>
                <a href="<?php echo e(route('ficheminiceurs.index', ['prospect_id' => $prospect->id])); ?>" class="btn btn-success">Fiche Miniceur</a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>nom</th>
                                        <th>prenom</th>
                                        <th>Date de Naissance</th>
                                        <th>Numéro de Téléphone</th>
                                        <th>Adresse</th>
                                        <th>Email</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><?php echo e($prospect->nom); ?></td>
                                        <td><?php echo e($prospect->prenom); ?></td>
                                        <td><?php echo e($prospect->date_naissance); ?></td>
                                        <td><?php echo e($prospect->telephone); ?></td>
                                        <td><?php echo e($prospect->adresse); ?></td>
                                        <td><?php echo e($prospect->email); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <br>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">Fiche épilation Du Client</div>
                    <div class="card-body">
                        <button type="button" class="btn btn-success float-right mb-2" data-bs-toggle="modal" data-bs-target="#createModal">
                            Ajouter des nouveaux détails
                        </button>

                        <!-- Create Modal -->
                        <div class="modal fade" id="createModal" tabindex="-1" aria-labelledby="createModalLabel" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="createModalLabel">Ajouter des nouveaux détails</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="<?php echo e(route('fiche_clients.store')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal-body">
                                            <!-- Add form fields for creating a new Fiche Client here -->
                                            <!-- Hidden input field to pass the prospect_id -->
                                            <input type="hidden" name="prospect_id" value="<?php echo e($prospect->id); ?>">
                                            <div class="mb-3">
                                                <label for="date" class="form-label">Date</label>
                                                <input type="date" class="form-control" id="date" name="date" required>
                                            </div>
                                            <div class="mb-3">
                                                <label for="parametre" class="form-label">Parametre</label>
                                                <input type="text" class="form-control" id="parametre" name="parametre" required>
                                            </div>
                                        </div>

                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- Edit Modal -->
                        <?php $__currentLoopData = $ficheClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ficheClient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modal fade" id="editModal<?php echo e($ficheClient->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel<?php echo e($ficheClient->id); ?>" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="editModalLabel<?php echo e($ficheClient->id); ?>">Modifier les données</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="<?php echo e(route('fiche_clients.update', $ficheClient->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <div class="modal-body">
                                            <!-- Edit form fields for the Fiche Client here -->
                                            <div class="mb-3">
                                                <label for="edit_date" class="form-label">Date</label>
                                                <input type="date" class="form-control" id="edit_date" name="date" value="<?php echo e($ficheClient->date); ?>" required>
                                            </div>
                                            <div class="mb-3">
                                                <label for="edit_parametre" class="form-label">Parametre</label>
                                                <input type="text" class="form-control" id="edit_parametre" name="parametre" value="<?php echo e($ficheClient->parametre); ?>" required>
                                            </div>
                                            <!-- Hidden input field for prospect_id -->
                                            <input type="hidden" name="prospect_id" value="<?php echo e($ficheClient->prospect_id); ?>">
                                            <!-- Add fields for other attributes as needed -->
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fermer</button>
                                            <button type="submit" class="btn btn-primary">Enregistrer</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Parametre</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $ficheClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ficheClient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($ficheClient->date); ?></td>
                                    <td><?php echo e($ficheClient->parametre); ?></td>
                                    <!-- Add cells for custom fields here -->
                                    
                                    <td>
                                        <?php if(auth()->user() && auth()->user()->isAdmin()): ?>
                                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($ficheClient->id); ?>">Modifier</button>
                                        <form action="<?php echo e(route('fiche_clients.destroy', $ficheClient->id)); ?>" method="POST" style="display: inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this Fiche Client?')">Suprimer</button>
                                        </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">Add Comment</div>
                    <div class="card-body">
                        <form action="<?php echo e(route('commantaire_epilations.store', ['prospect_id' => $prospect->id])); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <!-- Hidden input field to pass the prospect_id -->

                            <input type="hidden" name="prospect_id" value="<?php echo e($prospect->id); ?>">

                            <div class="form-group">
                                <label for="commentairEp">Comment :</label>
                                <textarea name="commentairEp" id="commentairEp" class="form-control" rows="3" required></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary">Add Comment</button>
                        </form>
                        <hr> <!-- Optional: Add a horizontal line to separate the forms -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">Comments</div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Comment</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($comment->commentairEp); ?></td>
                                    <td>
                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#editCommentModal<?php echo e($comment->id); ?>">Edit</button>
                                        <form action="<?php echo e(route('commantaire_epilations.destroy', $comment->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this comment?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__currentLoopData = $commantaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="editCommentModal<?php echo e($comment->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editCommentModalLabel<?php echo e($comment->id); ?>" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editCommentModalLabel<?php echo e($comment->id); ?>">Edit Commentaire Miniceur</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('commantaire_epilations.update', $comment->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="form-group">
                            <label for="commentairEp">Comment</label>
                            <input type="text" name="commentairEp" id="commentairEp" class="form-control" value="<?php echo e($comment->commentairEp); ?>">
                        </div>
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <script>
        function viewFicheClient(id) {
            // Use AJAX to fetch the fiche client data and populate the view modal
            $('#viewModal').modal('show');
        }

        function editFicheClient(id) {
            // Use AJAX to fetch the fiche client data and populate the edit modal
            $('#editModal').modal('show');
        }
    </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lasercli/public_html/app.laserclinic.ma/resources/views/fiche_clients/index.blade.php ENDPATH**/ ?>