
<?php $__env->startSection('content'); ?>
<main class="container mt-5">
    <div class="row">
        <div class="col-md-8">
            <h3>Fiche de paiment</h3>
        </div>
        <div class="col-md-4 text-right">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#editModal<?php echo e($prospect->id); ?>">Modifier les détails</button>
        </div>
    </div>
<div class="row mt-3">
    <div class="col-md-12">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Paramètre</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
    <?php if(empty($prospect->date) && empty($prospect->parametre)): ?>
    <tr>
        <td colspan="3" class="text-center">No fiche de paiment pour ce client</td>
    </tr>
    <?php else: ?>
    <tr>
        <td><?php echo e($prospect->date); ?></td>
        <td><?php echo e($prospect->parametre); ?></td>
        <td>
            <div class="btn-group">
                <button type="button" class="btn btn-sm btn-outline-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    Actions
                </button>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="#" onclick="deleteDateAndParametre('<?php echo e($prospect->id); ?>')"><i class="fas fa-trash-alt"></i> Supprimer</a>
                    <form id="deleteDateParametreForm<?php echo e($prospect->id); ?>" action="<?php echo e(route('prospects.deleteDateAndParametre', ['id' => $prospect->id])); ?>" method="POST" style="display: none;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                    </form>                                <!-- Add more actions as needed -->
                </div>
            </div>
        </td>
    </tr>
    <?php endif; ?>
</tbody>

    </div>
</div>
</main>
<div class="modal fade" id="editModal<?php echo e($prospect->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel<?php echo e($prospect->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="editModalLabel<?php echo e($prospect->id); ?>">Modifier les détails du prospect</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Form for editing prospect details -->
                <form action="<?php echo e(route('prospects.fiche', $prospect->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="form-group">
                        <label for="parametre">Paramètre</label>
                        <input type="text" class="form-control" id="parametre" name="parametre" value="<?php echo e($prospect->parametre); ?>">
                    </div>
                    <div class="form-group">
                        <label for="date">Date</label>
                        <input type="date" class="form-control" id="date" name="date" value="<?php echo e($prospect->date); ?>">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        var dropdownButtons = document.querySelectorAll('.dropdown-toggle');
        dropdownButtons.forEach(function(button) {
            button.addEventListener('click', function() {
                var dropdownMenu = this.nextElementSibling;
                if (dropdownMenu.classList.contains('show')) {
                    dropdownMenu.classList.remove('show');
                } else {
                    dropdownMenu.classList.add('show');
                }
            });
        });
    });
</script>
<script>
    document.addEventListener('click', function(event) {
        var dropdownMenus = document.querySelectorAll('.dropdown-menu');
        var dropdownToggles = document.querySelectorAll('.dropdown-toggle');
        var isClickWithinDropdown = false;

        // Check if the click is within any dropdown menu
        dropdownMenus.forEach(function(menu) {
            if (menu.contains(event.target)) {
                isClickWithinDropdown = true;
            }
        });

        // Check if the click is within any dropdown toggle
        dropdownToggles.forEach(function(toggle) {
            if (toggle.contains(event.target)) {
                isClickWithinDropdown = true;
            }
        });

        // If click is not within any dropdown menu or toggle, close all dropdown menus
        if (!isClickWithinDropdown) {
            dropdownMenus.forEach(function(menu) {
                menu.classList.remove('show');
            });
        }
    });

    // Close dropdown menu when clicking on any item within it
    document.querySelectorAll('.dropdown-item').forEach(function(item) {
        item.addEventListener('click', function() {
            var dropdownMenu = this.closest('.dropdown-menu');
            dropdownMenu.classList.remove('show');
        });
    });
</script>  
<script>
    function deleteDateAndParametre(id) {
        if (confirm("Are you sure you want to delete the date and parametre?")) {
            // Submit the form via AJAX
            var form = document.getElementById('deleteDateParametreForm' + id);
            form.submit();
        }
    }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\GTO\Desktop\gestionservice\resources\views/prospect/ficheDePaiment.blade.php ENDPATH**/ ?>