
<?php $__env->startSection('content'); ?>
<main class="container mt-5">
    
    <div class="row">
        <div class="col-md-8">
            <h3>Liste des Services</h3>
        </div>
        <div class="col-md-4 text-right">
            <a href="<?php echo e(route('services.create')); ?>" class="btn btn-primary">Ajouter un Service</a>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-12">
            <table class="table table-striped">
                <thead>
                    <tr>
                        
                        <th>Services</th>
                        <th>Prix</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($service->nom_service); ?> <?php echo e($service->nom_grandservice); ?></td>
                        <td><?php echo e($service->prix_service); ?></td>
                        <td>
                        <div class="btn-group">
    <button type="button" class="btn btn-sm btn-outline-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        Actions
    </button>
    <div class="dropdown-menu">
        <a class="dropdown-item view-details" href="#" data-toggle="modal" data-target="#editModal<?php echo e($service->id); ?>"><i class="fas fa-edit"></i> Modifier</a>
        
        <?php if(!empty($service->nom_grandservice)): ?>
            <a class="dropdown-item view-details" href="<?php echo e(route('sousservices.index', ['service_id' => $service->id])); ?>"><i class="fas fa-edit"></i> Sous_Service</a>
        <?php endif; ?>
        
        <form action="<?php echo e(route('services.destroy', $service->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button type="submit" class="dropdown-item" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce service?')"><i class="fas fa-trash-alt"></i> Supprimer</button>
        </form>
    </div>
</div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    
</main>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        var dropdownButtons = document.querySelectorAll('.dropdown-toggle');
        dropdownButtons.forEach(function(button) {
            button.addEventListener('click', function() {
                var dropdownMenu = this.nextElementSibling;
                if (dropdownMenu.classList.contains('show')) {
                    dropdownMenu.classList.remove('show');
                } else {
                    dropdownMenu.classList.add('show');
                }
            });
        });
    });
</script>
<script>
    document.addEventListener('click', function(event) {
        var dropdownMenus = document.querySelectorAll('.dropdown-menu');
        var dropdownToggles = document.querySelectorAll('.dropdown-toggle');
        var isClickWithinDropdown = false;

        // Check if the click is within any dropdown menu
        dropdownMenus.forEach(function(menu) {
            if (menu.contains(event.target)) {
                isClickWithinDropdown = true;
            }
        });

        // Check if the click is within any dropdown toggle
        dropdownToggles.forEach(function(toggle) {
            if (toggle.contains(event.target)) {
                isClickWithinDropdown = true;
            }
        });

        // If click is not within any dropdown menu or toggle, close all dropdown menus
        if (!isClickWithinDropdown) {
            dropdownMenus.forEach(function(menu) {
                menu.classList.remove('show');
            });
        }
    });

    // Close dropdown menu when clicking on any item within it
    document.querySelectorAll('.dropdown-item').forEach(function(item) {
        item.addEventListener('click', function() {
            var dropdownMenu = this.closest('.dropdown-menu');
            dropdownMenu.classList.remove('show');
        });
    });
</script>  


<?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editModal<?php echo e($service->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel<?php echo e($service->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="editModalLabel<?php echo e($service->id); ?>">
                    <?php if(!empty($service->nom_service)): ?>
                        Modifier les Détails du Service
                    <?php else: ?>
                        Modifier le Nom du Grand Service
                    <?php endif; ?>
                </h5>
            </div>
            <div class="modal-body">
                <!-- Form for editing service details -->
                <form action="<?php echo e(route('services.update', $service->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <?php if(!empty($service->nom_service)): ?>
                    <div class="form-group">
                        <label for="nom_service">Service</label>
                        <input type="text" class="form-control" id="nom_service" name="nom_service" value="<?php echo e($service->nom_service); ?>">
                    </div>
                    <div class="form-group">
                        <label for="prix_service">Prix</label>
                        <input type="text" class="form-control" id="prix_service" name="prix_service" value="<?php echo e($service->prix_service); ?>">
                    </div>
                    <?php else: ?>
                    <div class="form-group">
                        <label for="nom_grandservice">Nom du Grand Service</label>
                        <input type="text" class="form-control" id="nom_grandservice" name="nom_grandservice" value="<?php echo e($service->nom_grandservice); ?>">
                    </div>
                    <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
            </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gestionservice\resources\views/service/index.blade.php ENDPATH**/ ?>