

<?php $__env->startSection('content'); ?>

<main class="container mt-5">
    
    <div class="row">
        <div class="col-md-8">
            <h3>Liste des Services</h3>
        </div>
        <div class="col-md-4 text-right">
            <a href="<?php echo e(route('services.create')); ?>" class="btn btn-success">Ajouter un Service</a>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-12">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Services</th>
                        <th>Prix</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($service->nom_service); ?> <?php echo e($service->nom_grandservice); ?></td>
                        <td><?php echo e($service->prix_service); ?></td>
                        <td>
                            <div class="btn-group">
                            <?php if(auth()->user() && auth()->user()->isAdmin()): ?>

                                <a href="#" class="btn btn-sm btn-warning mr-1" data-toggle="modal" data-target="#editModal<?php echo e($service->id); ?>"><i class="fas fa-edit"></i> Modifier</a>
                            <?php endif; ?>
                                <?php if(!empty($service->nom_grandservice)): ?>
                                    <a href="<?php echo e(route('sousservices.index', ['service_id' => $service->id])); ?>" class="btn btn-sm btn-info mr-1"><i class="fas fa-edit"></i> Sous_Service</a>
                                <?php endif; ?>
                                <?php if(auth()->user() && auth()->user()->isAdmin()): ?>

                                <form action="<?php echo e(route('services.destroy', $service->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger mr-1" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce service?')"><i class="fas fa-trash-alt"></i> Supprimer</button>
                                </form>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editModal<?php echo e($service->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel<?php echo e($service->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title" id="editModalLabel<?php echo e($service->id); ?>">
                    <?php if(!empty($service->nom_service)): ?>
                        Modifier les Détails du Service
                    <?php else: ?>
                        Modifier le Nom du Grand Service
                    <?php endif; ?>
                </h5>
            </div>
            <div class="modal-body">
                <!-- Form for editing service details -->
                <form action="<?php echo e(route('services.update', $service->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <?php if(!empty($service->nom_service)): ?>
                    <div class="form-group">
                        <label for="nom_service">Service</label>
                        <input type="text" class="form-control" id="nom_service" name="nom_service" value="<?php echo e($service->nom_service); ?>">
                    </div>
                    <div class="form-group">
                        <label for="prix_service">Prix</label>
                        <input type="text" class="form-control" id="prix_service" name="prix_service" value="<?php echo e($service->prix_service); ?>">
                    </div>
                    <?php else: ?>
                    <div class="form-group">
                        <label for="nom_grandservice">Nom du Grand Service</label>
                        <input type="text" class="form-control" id="nom_grandservice" name="nom_grandservice" value="<?php echo e($service->nom_grandservice); ?>">
                    </div>
                    <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-success">Enregistrer les modifications</button>
            </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lasercli/public_html/app.laserclinic.ma/resources/views/service/index.blade.php ENDPATH**/ ?>