
<?php $__env->startSection('content'); ?>
<main class="container mt-5">
    <div class="row">
        <div class="col-md-8">
            <h3>Liste des prospects</h3>
        </div>
        <div class="col-md-4 text-right">
            <a href="<?php echo e(route('prospects.create')); ?>" class="btn btn-primary">Ajouter un prospect</a>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-12">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Prénom</th>
                        <th>Numéro de téléphone</th>
                        <th>Date de Rendez-vous</th>
                        <th>Fiche</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $prospects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prospect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($prospect->nom); ?></td>
                        <td><?php echo e($prospect->prenom); ?></td>
                        <td><?php echo e($prospect->telephone); ?></td>
                        <td>
                            <?php if($rendezvous[$prospect->id]->isNotEmpty()): ?>
                                <?php echo e($rendezvous[$prospect->id]->last()->date_rv); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <a class="btn btn-sm btn-custom-primary" href="<?php echo e(route('fiche_clients.index', ['prospect_id' => $prospect->id])); ?>"><i class="fas fa-edit"></i> Fiche de Client</a>
                            <a class="btn btn-sm btn-custom-primary" href="<?php echo e(route('fiche_paiements.index', ['prospect_id' => $prospect->id])); ?>"><i class="fas fa-edit"></i> Fiche de Paiement</a>
                        </td>
                        <td>
                        <a class="btn btn-sm btn-info" href="#" data-toggle="modal" data-target="#viewModal<?php echo e($prospect->id); ?>"><i class="fas fa-eye"></i> Consulter</a>
                        <?php if(auth()->user() && auth()->user()->isAdmin()): ?>
    <a class="btn btn-sm btn-primary" href="#" data-toggle="modal" data-target="#editModal<?php echo e($prospect->id); ?>"><i class="fas fa-edit"></i> Modifier</a>
    <form action="<?php echo e(route('prospects.destroy', $prospect->id)); ?>" method="POST" style="display: inline;">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce prospect?')"><i class="fas fa-trash-alt"></i> Supprimer</button>
    </form>
<?php endif; ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<?php $__currentLoopData = $prospects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prospect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="viewModal<?php echo e($prospect->id); ?>" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel<?php echo e($prospect->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="viewModalLabel<?php echo e($prospect->id); ?>">Détails du Prospect</h5>
            </div>
            <div class="modal-body">
                <!-- Affichez les détails du prospect ici -->
                <p><strong>Nom:</strong> <?php echo e($prospect->nom); ?></p>
                <p><strong>Prénom:</strong> <?php echo e($prospect->prenom); ?></p>
                <p><strong>Numéro de téléphone:</strong> <?php echo e($prospect->telephone); ?></p>
                <p><strong>Adresse:</strong> <?php echo e($prospect->adresse); ?></p>
                <p><strong>email:</strong> <?php echo e($prospect->email); ?></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">Fermer</button>
            </div>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__currentLoopData = $prospects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prospect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editModal<?php echo e($prospect->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel<?php echo e($prospect->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="editModalLabel<?php echo e($prospect->id); ?>">Modifier les Détails du Prospect</h5>
            </div>
            <div class="modal-body">
                <!-- Form for editing prospect details -->
                <form action="<?php echo e(route('prospects.update', $prospect->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="form-group">
                        <label for="telephone">Numéro de téléphone</label>
                        <input type="text" class="form-control" id="telephone" name="telephone" value="<?php echo e($prospect->telephone); ?>">
                    </div>
                    <div class="form-group">
                        <label for="nom">Nom</label>
                        <input type="text" class="form-control" id="nom" name="nom" value="<?php echo e($prospect->nom); ?>">
                    </div>
                    <div class="form-group">
                        <label for="prenom">Prénom</label>
                        <input type="text" class="form-control" id="prenom" name="prenom" value="<?php echo e($prospect->prenom); ?>">
                    </div>
                    <div class="form-group">
                        <label for="date_naissance">Date de naissance</label>
                        <input type="date" class="form-control" id="date_naissance" name="date_naissance" value="<?php echo e($prospect->date_naissance); ?>">
                    </div>
                    <div class="form-group">
                        <label for="adresse">Adresse</label>
                        <textarea class="form-control" id="adresse" name="adresse" rows="3"><?php echo e($prospect->adresse); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" class="form-control" id="email" name="email" value="<?php echo e($prospect->email); ?>">
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
            </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lasercli/public_html/app.laserclinic.ma/resources/views/prospect/index.blade.php ENDPATH**/ ?>