

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">Prospect Data</div>
                    <div class="card-body">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>nom</th>
                                    <th>prenom</th>
                                    <th>Date de Naissance</th>
                                    <th>Numéro de Téléphone</th>
                                    <th>Actions</th>
                                    <!-- Add column headers for other prospect fields if needed -->
                                </tr>
                            </thead>
                            <tbody>
                                    <tr>
                                        <td><?php echo e($prospect->nom); ?></td>
                                        <td><?php echo e($prospect->prenom); ?></td>
                                        <td><?php echo e($prospect->date_naissance); ?></td>
                                        <td><?php echo e($prospect->adresse); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('fiche_clients.index', ['prospect_id' => $prospect->id])); ?>" class="btn btn-success">Fiche Epilation</a>
                                                <a href="<?php echo e(route('ficheminiceurs.index', ['prospect_id' => $prospect->id])); ?>" class="btn btn-success">Fiche Miniceur</a>
                                         </td>
                                        <!-- Add cells for other prospect fields if needed -->
                                    </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <br> <!-- Add some space between the two tables -->
            </div>
        </div>
    </div>




    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">Fiche Miniceurs</div>
                    <div class="card-body">
                    <div class="mb-3">
                         <button type="button" class="btn btn-success" data-toggle="modal" data-target="#createModal">Create New Fiche Miniceur</button>
                    </div>

                    <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="createModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createModalLabel">Create New Fiche Miniceur</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Add your form for creating a new Fiche Miniceur here -->
                <form action="<?php echo e(route('ficheminiceurs.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <!-- Add form fields for Fiche Miniceur attributes -->
                    <?php $__currentLoopData = $prospects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prospect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <input type="hidden" name="prospect_id" value="<?php echo e($prospect->id); ?>">
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="form-group">
                        <label for="date">Date:</label>
                        <input type="date" name="date" id="date" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="prestation">Prestation:</label>
                        <input type="text" name="prestation" id="prestation" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="vente_1">Vente 1:</label>
                        <input type="number" name="vente_1" id="vente_1" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="vente_2">Vente 2:</label>
                        <input type="number" name="vente_2" id="vente_2" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="vente_3">Vente 3:</label>
                        <input type="number" name="vente_3" id="vente_3" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="cuise_1">Cuise 1:</label>
                        <input type="text" name="cuise_1" id="cuise_1" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="cuise_2">Cuise 2:</label>
                        <input type="text" name="cuise_2" id="cuise_2" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="cuise_3">Cuise 3:</label>
                        <input type="text" name="cuise_3" id="cuise_3" class="form-control" required>
                    </div>
                    <!-- Add other fields -->
                    <button type="submit" class="btn btn-primary">Create Fiche Miniceur</button>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewModalLabel">View Fiche Miniceur</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Add your content to display the stored data here -->
                <?php $__currentLoopData = $ficheminiceurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ficheminiceur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>ID:</strong> <?php echo e($ficheminiceur->id); ?></p>
                        <p><strong>Date:</strong> <?php echo e($ficheminiceur->date); ?></p>
                        <p><strong>Prestation:</strong> <?php echo e($ficheminiceur->prestation); ?></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Vente:</strong></p>
                        <div class="vente-container">
                            <p><?php echo e($ficheminiceur->vente_1); ?></p>
                            <p><?php echo e($ficheminiceur->vente_2); ?></p>
                            <p><?php echo e($ficheminiceur->vente_3); ?></p>
                        </div>
                        <p><strong>Cuise:</strong></p>
                        <div class="cuise-container">
                            <p><?php echo e($ficheminiceur->cuise_1); ?></p>
                            <hr class="separator">
                            <p><?php echo e($ficheminiceur->cuise_2); ?></p>
                            <hr class="separator">
                            <p><?php echo e($ficheminiceur->cuise_3); ?></p>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<?php $__currentLoopData = $ficheminiceurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ficheminiceur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="editModal<?php echo e($ficheminiceur->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel<?php echo e($ficheminiceur->id); ?>" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel<?php echo e($ficheminiceur->id); ?>">Edit Fiche Miniceur</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="editForm<?php echo e($ficheminiceur->id); ?>" action="<?php echo e(route('ficheminiceurs.update', ['ficheminiceur' => $ficheminiceur->id])); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?> <!-- Use PUT method for update -->
                        <div class="form-group">
                            <label for="edit_date<?php echo e($ficheminiceur->id); ?>">Date:</label>
                            <input type="date" name="date" id="edit_date<?php echo e($ficheminiceur->id); ?>" class="form-control" value="<?php echo e($ficheminiceur->date); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_prestation<?php echo e($ficheminiceur->id); ?>">Prestation:</label>
                            <input type="text" name="prestation" id="edit_prestation<?php echo e($ficheminiceur->id); ?>" class="form-control" value="<?php echo e($ficheminiceur->prestation); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_vente_1<?php echo e($ficheminiceur->id); ?>">Vente 1:</label>
                            <input type="number" name="vente_1" id="edit_vente_1<?php echo e($ficheminiceur->id); ?>" class="form-control" value="<?php echo e($ficheminiceur->vente_1); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_vente_2<?php echo e($ficheminiceur->id); ?>">Vente 2:</label>
                            <input type="number" name="vente_2" id="edit_vente_2<?php echo e($ficheminiceur->id); ?>" class="form-control" value="<?php echo e($ficheminiceur->vente_2); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_vente_3<?php echo e($ficheminiceur->id); ?>">Vente 3:</label>
                            <input type="number" name="vente_3" id="edit_vente_3<?php echo e($ficheminiceur->id); ?>" class="form-control" value="<?php echo e($ficheminiceur->vente_3); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_cuise_1<?php echo e($ficheminiceur->id); ?>">Cuise 1:</label>
                            <input type="text" name="cuise_1" id="edit_cuise_1<?php echo e($ficheminiceur->id); ?>" class="form-control" value="<?php echo e($ficheminiceur->cuise_1); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_cuise_2<?php echo e($ficheminiceur->id); ?>">Cuise 2:</label>
                            <input type="text" name="cuise_2" id="edit_cuise_2<?php echo e($ficheminiceur->id); ?>" class="form-control" value="<?php echo e($ficheminiceur->cuise_2); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_cuise_3<?php echo e($ficheminiceur->id); ?>">Cuise 3:</label>
                            <input type="text" name="cuise_3" id="edit_cuise_3<?php echo e($ficheminiceur->id); ?>" class="form-control" value="<?php echo e($ficheminiceur->cuise_3); ?>" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Prestation</th>
                                    <th>Vente</th>
                                    <th>Cuise</th>
                                    <!-- Add headers for custom fields -->
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $ficheminiceurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ficheminiceur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($ficheminiceur->id); ?></td>
                                        <td><?php echo e($ficheminiceur->date); ?></td>
                                        <td><?php echo e($ficheminiceur->prestation); ?></td>
                                        <td>
                                            <div class="vente-container">
                                                <div class="vente"><?php echo e($ficheminiceur->vente_1); ?></div>
                                                <div class="vente"><?php echo e($ficheminiceur->vente_2); ?></div>
                                                <div class="vente"><?php echo e($ficheminiceur->vente_3); ?></div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="cuise-container">
                                                <div class="cuise"><?php echo e($ficheminiceur->cuise_1); ?></div>
                                                <div class="cuise"><?php echo e($ficheminiceur->cuise_2); ?></div>
                                                <div class="cuise"><?php echo e($ficheminiceur->cuise_3); ?></div>
                                            </div>
                                        </td>
                                        <!-- Add cells for custom fields -->
                                        <td>
                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#viewModal">
                                            View
                                        </button>

                                        <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#editModal<?php echo e($ficheminiceur->id); ?>">
        Edit
    </button>                                            <form action="<?php echo e(route('ficheminiceurs.destroy', $ficheminiceur->id)); ?>" method="POST" style="display: inline-block;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this Fiche Miniceur?')">Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-md-12">
            <h3>Commentaires existants :</h3>
            <!-- Affichage des commantaires existants -->
            <?php $__currentLoopData = $commantaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commantaire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card mb-3">
                    <div class="card-body">
                        <p><?php echo e($commantaire->commantaire_epilation); ?></p>
                        <!-- Affichez d'autres détails du commantaire si nécessaire -->
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <style>
        .vente-container,
        .cuise-container {
            display: flex;
        }

        .vente,
        .cuise {
            border: 1px solid #ccc;
            padding: 5px;
            margin-right: 5px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\GTO\Desktop\gestionservice\resources\views/ficheminiceurs/index.blade.php ENDPATH**/ ?>