<?php
use App\Models\Prospect;
$prospects = Prospect::all();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laser Clinic</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Autres balises meta et liens CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/style2.css')); ?>">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>
</head>
<body>
    
<nav class="navbar navbar-expand-lg navbar-light navbar-custom">
    <a class="navbar-brand" href="/home"><img src="<?php echo e(asset('images/10.JPG')); ?>" alt="Logo" class="logo-circle"></a>

    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon navbar-toggler-icon-custom"></span>
    </button>
   <div class="collapse navbar-collapse" id="navbarSupportedContent">
    <ul class="navbar-nav ml-auto " style="margin-right: 80px;" >
        <?php if(auth()->guard()->guest()): ?>
            <?php if(Route::has('login')): ?>8
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                </li>
            <?php endif; ?>
            <?php if(Route::has('register')): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                </li>
            <?php endif; ?>
        <?php else: ?>
            <li class="nav-item dropdown">
                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                    <?php echo e(Auth::user()->name); ?>

                </a>
                <div  class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                       onclick="event.preventDefault();
                                     document.getElementById('logout-form').submit();">
                        <?php echo e(__('Logout')); ?>

                    </a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </li>
        <?php endif; ?>
    </ul>
</div>   
</nav>
<div class="container-fluid">
    <div class="row">
        <aside class="col-md-3 aside-container">
            <h1 class="clinic-heading">Laser Clinic</h1>
                <div class="search-container">
                    <input type="text" class="form-control search-input" id="recherche" placeholder="Recherche...">
                    <a href="#" class="search-btn">
                        <i class="fas fa-search"></i>
                    </a>
                 </div>
            <!-- Modal de popup -->
                <div class="modal fade" id="searchResultsModal" tabindex="-1" role="dialog" aria-labelledby="searchResultsModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="searchResultsModalLabel">Résultats de la recherche</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <table class="table table-striped" id="searchResultsTable">
                                    <thead>
                                        <tr>
                                            <th>Numéro de téléphone</th>
                                            <th>Nom</th>
                                            <th>Prénom</th>
                                            <th>Date de naissance</th>
                                            <th>Adresse</th>
                                        </tr>
                                    </thead>
                                    <tbody id="searchResultsBody">
                                        <!-- Search results will be dynamically inserted here -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            <ul>
                <li><a href="<?php echo e(route('prospects.create')); ?>"><i class="fas fa-user-plus"></i> Ajouter un Prospect </a></li>
                <li><a href=""><i class="fas fa-calendar-plus"></i> Ajouter un RV </a></li>
                <li class="menu-parent">
                    <a href="#"><i class="fas fa-bars"></i> Menu </a>
                    <ul class="sub-menu">
                        <li><a href="<?php echo e(route('prospects.index')); ?>"><i class="fas fa-list"></i> Liste des Prospects</a></li>
                        <li><a href="#"><i class="fas fa-chart-line"></i> CA du jour</a></li>
                    </ul>
                </li>
                <li class="menu-parent">
                    <a href="#"><i class="fas fa-cogs"></i> Management des services </a>
                    <ul class="sub-menu">
                        <li><a href=""><i class="fas fa-plus-circle"></i> Ajouter un service </a></li>
                        <li><a href=""><i class="fas fa-list-alt"></i> Liste des services </a></li>
                    </ul>
                </li>
                <li class="menu-parent">
                    <a href="#"><i class="fas fa-cog"></i> Gestion des machines </a>
                    <ul class="sub-menu">
                        <li><a href=""><i class="fas fa-plus-circle"></i> Ajouter une machine </a></li>
                        <li><a href=""><i class="fas fa-list-alt"></i> Liste des machines </a></li>
                    </ul>
                </li>              
            </ul>
        </aside>
        <main class="col-md-9 content">
            <!-- Votre contenu principal ici -->
            <?php echo $__env->yieldContent('content'); ?>

        </main>
    </div>
</div>
<!-- Scripts Bootstrap / javascript-->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script>
    const prospects = <?php echo json_encode($prospects, 15, 512) ?>;

    document.addEventListener("DOMContentLoaded", function() {
        const searchInput = document.getElementById('recherche');
        const searchBtn = document.querySelector('.search-btn');
        const searchResultsModal = document.getElementById('searchResultsModal');
        const searchResultsTableBody = document.getElementById('searchResultsBody');

        function performSearch() {
            const searchTerm = searchInput.value.trim().toLowerCase();
            let foundResults = false;

            // Clear previous search results
            searchResultsTableBody.innerHTML = '';

            // Perform search only if the search term is not empty
            if (searchTerm !== '') {
                prospects.forEach(function(prospect) {
                    const telephone = prospect.telephone.trim().toLowerCase();
                    if (telephone.includes(searchTerm)) {
                        // Append the prospect data to the search results table
                        const row = document.createElement('tr');
                        row.innerHTML = `
                            <td>${prospect.telephone}</td>
                            <td>${prospect.nom}</td>
                            <td>${prospect.prenom}</td>
                            <td>${prospect.date_naissance}</td>
                            <td>${prospect.adresse}</td>
                        `;
                        searchResultsTableBody.appendChild(row);
                        foundResults = true;
                    }
                });

                // Show the modal if there are search results
                if (foundResults) {
                    $(searchResultsModal).modal('show');
                } else {
                    alert('Aucun résultat trouvé');
                }
            }
        }

        searchBtn.addEventListener('click', performSearch);

        searchInput.addEventListener('keypress', function(event) {
            // Check if the Enter key is pressed (key code 13)
            if (event.keyCode === 13) {
                performSearch();
            }
        });
    });
</script>

</body>
</html>
<?php /**PATH C:\Users\GTO\Desktop\gestionservice\resources\views/layouts/app.blade.php ENDPATH**/ ?>