

<?php $__env->startSection('content'); ?>
<main>
    <div class="container-fluid">
        <h1 class="heading">Fiches des paiements</h1>

        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Prestation</th>
                        <th>Paiement</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $rendezvous; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($appointment->date_rv); ?></td>
                        <td><?php echo e($appointment->service->nom_service); ?></td>
                        <td><?php echo e($appointment->prix_rv); ?></td>
                        <td>
                        <?php if(auth()->user() && auth()->user()->isAdmin()): ?>
                            <a class="btn btn-primary" href="#" data-toggle="modal" data-target="#editModal<?php echo e($appointment->id); ?>"><i class="fas fa-edit"></i> Modifier</a>
                            <form action="<?php echo e(route('rendezvous.destroyForFiche', $appointment->id)); ?>" method="POST" style="display: inline-block;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <input type="hidden" name="prospect_id" value="<?php echo e($appointment->prospect_id); ?>">
                                <button type="submit" class="btn btn-danger" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce rendez-vous?')"><i class="fas fa-trash-alt"></i> Supprimer</button>
                            </form>
                        <?php endif; ?>    
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Edit Modals -->
    <?php $__currentLoopData = $rendezvous; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="editModal<?php echo e($rv->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel<?php echo e($rv->id); ?>" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="editModalLabel<?php echo e($rv->id); ?>">Modifier les Détails du Rendez-vous</h5>
                </div>
                <div class="modal-body">
                    <!-- Form for editing rendez-vous details -->
                    <form action="<?php echo e(route('rendezvous.updateForFiche', $rv->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="form-group">
                            <label for="date_rv">Date du rendez-vous</label>
                            <input type="date" class="form-control" id="date_rv" name="date_rv" value="<?php echo e($rv->date_rv); ?>">
                        </div>
                        <div class="form-group">
                            <label for="heure_rv">Heure du rendez-vous</label>
                            <input type="time" class="form-control" id="heure_rv" name="heure_rv" value="<?php echo e($rv->heure_rv); ?>">
                        </div>
                        <div class="form-group">
                            <label for="prix_rv">Prix du rendez-vous</label>
                            <input type="text" class="form-control" id="prix_rv" name="prix_rv" value="<?php echo e($rv->prix_rv); ?>">
                        </div>
                        <div class="form-group">
                            <label for="prospect_id<?php echo e($rv->id); ?>">Prospect</label>
                            <select class="form-control" id="prospect_id<?php echo e($rv->id); ?>" name="prospect_id">
                                <?php $__currentLoopData = $prospects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prospect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($prospect->id); ?>" <?php echo e($rv->prospect_id == $prospect->id ? 'selected' : ''); ?>><?php echo e($prospect->nom); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="service_id<?php echo e($rv->id); ?>">Service</label>
                            <select class="form-control" id="service_id<?php echo e($rv->id); ?>" name="service_id">
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($service->id); ?>" <?php echo e($rv->service_id == $service->id ? 'selected' : ''); ?>><?php echo e($service->nom_service); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
                </div>
                </form>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <script>
        function confirmDelete(id) {
            if (confirm('Are you sure you want to delete this record?')) {
                document.getElementById('deleteForm' + id).submit();
            }
        }
    </script>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lasercli/public_html/app.laserclinic.ma/resources/views/fiche_paiements/index.blade.php ENDPATH**/ ?>