

<?php $__env->startSection('content'); ?>
    <style>
        .calendar {
            font-family: Arial, sans-serif;
            border-collapse: collapse;
            width: 100%;
            margin-top: 20px;
        }

        .calendar th {
            background-color: #2d8cff;
            color: white;
            font-weight: bold;
            padding: 15px;
            text-align: center;
            border: 1px solid #ddd;
        }

        .calendar td {
            padding: 20px;
            text-align: center;
            border: 1px solid #ddd;
        }

        .calendar tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        .hour-column {
            width: 100px; /* Adjust as needed */
            background-color: #2d8cff;
            color: white;
        }

        .event-column {
            width: calc(100% - 100px); /* Adjust as needed */
            vertical-align: top;
        }

        .event-box {
            border: 1px solid #ddd;
            padding: 30px;
            margin-bottom: 10px;
            display: block;
            text-decoration: none;
            color: #333;
            transition: background-color 0.3s ease;
            cursor: pointer;
        }
        /* Popup */
      .popup {
    display: none;
    position: fixed;
    left: 50%;
    top: 50%;
    transform: translate(-50%, -50%);
    background-color: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
    max-width: 400px;
    padding: 20px;
}

.popup-content {
    position: relative;
}

.popup-close {
    position: absolute;
    top: 10px;
    right: 10px;
    font-size: 24px;
    cursor: pointer;
    color: #aaa;
}

.popup-header {
    font-size: 20px;
    font-weight: bold;
    color: #333;
    margin-bottom: 20px;
}

.popup-description p {
    margin-bottom: 10px;
}

.status-form label,
.price-toggle label {
    display: block;
    margin-bottom: 5px;
    font-weight: bold;
    color: #333;
}

.status-form select,
.price-input {
    width: 100%;
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 5px;
    background-color: #f9f9f9;
    color: #333;
    font-size: 16px;
    margin-bottom: 10px;
    outline: none;
}

.price-toggle input[type="checkbox"] {
    margin-right: 5px;
}

.price-toggle label {
    cursor: pointer;
}

.update-status-button {
    background-color: #2d8cff;
    color: #fff;
    border: none;
    border-radius: 5px;
    padding: 10px 20px;
    font-size: 16px;
    cursor: pointer;
    transition: background-color 0.3s ease;
}

.update-status-button:hover {
    background-color: #1f6dbb;
}

        .confirm-button {
            background-color: #2196F3; 
            color: white;
            border-radius: 5px;
        }

        .check-button {
            background-color:  #4CAF50; 
            color: white;
            border-radius: 5px;
        }

        .regler-button {
            background-color: #FFD700; 
            color: white;
            border-radius: 5px;
        }

        .cancel-button {
            background-color: #F44336; /* Red */
            color: white;
            border-radius: 5px;
        }

        .fiche-button {
            background-color: #FFC107; /* Yellow */
            color: #333;
            border-radius: 5px;
        }

        /* Optional: Add hover effects for better user experience */
        .confirm-button:hover, .check-button:hover, .regler-button:hover, .cancel-button:hover, .fiche-button:hover {
            opacity: 0.8;
            cursor: pointer;
        }
        .confirm {
    border-color: #2196F3; /* Change border color for confirm status */
}

.check-in {
    border-color: #4CAF50; /* Change border color for check-in status */
}

.regler {
    border-color: #FFD700; /* Change border color for regler status */
}

.annuler {
    border-color: #F44336; /* Change border color for annuler status */
}
.fiche-client-button {
            background-color: #FFC107; /* Yellow */
            color: #333;
            border-radius: 5px;
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            display: inline-block;
            margin-top: 10px;
            text-decoration: none; /* Ensure it looks like a button */
        }

        .fiche-client-button:hover {
            background-color: #e0a800; /* Darker shade of yellow on hover */
        }
        .date-selector {
            margin-bottom: 20px;
        }

        .date-selector select {
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
            outline: none;
            cursor: pointer;
        }
        .date-selection {
    text-align: center;
    margin-bottom: 20px;
}

.current-date {
    font-size: 24px;
    color: #333;
    margin-bottom: 10px;
    font-weight: bold;
}

label {
    font-size: 18px;
    color: #555;
    margin-bottom: 10px;
    display: block;
}
@media (max-width: 768px) {
            .aside-container {
                display: 50%;
            }
            .content {
                width: 100%;
            }
        }
    </style>
         <div class="date-selection">
            <h1 id="current-date">la date d'aujourd'hui: <?php echo e(date('Y-m-d')); ?></h1>
            <label for="select-date">Sélectionner une date:</label>
        <input type="date" id="select-date">
    </div>

 <div class="calendar">
    <table>
        <thead>
            <tr>
                <th class="hour-column">Heure</th>
                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($service->nom_service !== null): ?>
    <th class="event-column"><?php echo e($service->nom_service); ?></th>
    <?php endif; ?>
    <?php if($service->nom_grandservice !== null): ?>
        <th class="event-column"><?php echo e($service->nom_grandservice); ?></th>
    <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tr>
        </thead>
        <tbody>
            <?php for($hour = 7; $hour < 31; $hour++): ?>
                <tr>
                    <td class="hour-column"><?php echo e(str_pad($hour % 24, 2, '0', STR_PAD_LEFT)); ?>:00</td>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td class="event-column">
                            <?php $__currentLoopData = $rendezvous; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $statusClass = '';
                                    switch ($appointment->statu) {
                                        case 'confirm':
                                            $statusClass = 'confirm';
                                            break;
                                        case 'check-in':
                                            $statusClass = 'check-in';
                                            break;
                                        case 'regler':
                                            $statusClass = 'regler';
                                            break;
                                        case 'annuler':
                                            $statusClass = 'annuler';
                                            break;
                                        case 'fiche-client':
                                            $statusClass = 'fiche-client';
                                            break;
                                    }
                                ?>
                                
                                <?php if(date('H:00', strtotime($appointment->heure_rv)) === str_pad($hour % 24, 2, '0', STR_PAD_LEFT) . ':00' && $appointment->service_id == $service->id): ?>
                                <a class="event-box <?php echo e($statusClass); ?>" data-date="<?php echo e(date('Y-m-d', strtotime($appointment->date_rv))); ?>" onclick="showPopup('<?php echo e($appointment->prospect->nom); ?>', 'Description of Service ID: <?php echo e($appointment->service_id); ?>', this, <?php echo e($appointment->id); ?>)">
    <?php echo e($appointment->prospect->nom); ?>, heure: <?php echo e(substr($appointment->heure_rv, 0, 5)); ?>, prix: <?php echo e($appointment->prix_rv); ?>

</a>


                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            <?php endfor; ?>
        </tbody>
    </table>
</div>

    <!-- Popup -->
    <?php $__currentLoopData = $rendezvous; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div id="popup-<?php echo e($appointment->id); ?>" class="popup">
    <div class="popup-content">
        <span class="popup-close" onclick="hidePopup('<?php echo e($appointment->id); ?>')">x</span>
        <div class="popup-header">Appointment Details</div>
        <div class="popup-description">
            <p><strong>Name:</strong> <?php echo e($appointment->prospect->nom); ?></p>
            <p><strong>Service:</strong> <?php echo e($appointment->service->nom_service); ?></p>
            <p><strong>Date:</strong> <?php echo e($appointment->date_rv); ?></p>
            <p><strong>Time:</strong> <?php echo e($appointment->heure_rv); ?></p>
        </div>
        <!-- Form for updating status with price field -->
        <form action="<?php echo e(route('update.status', ['id' => $appointment->id])); ?>" method="POST" id="status-form-<?php echo e($appointment->id); ?>" class="status-form">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="rendezvous_id" value="<?php echo e($appointment->id); ?>">
    <input type="hidden" name="statu" id="statu-<?php echo e($appointment->id); ?>"> <!-- Hidden input for status -->
    <button type="button" class="confirm-button" onclick="updateStatus('<?php echo e($appointment->id); ?>', 'confirm')">Confirmer</button>
    <button type="button" class="check-button" onclick="updateStatus('<?php echo e($appointment->id); ?>', 'check-in')">Check-in</button>
    <button type="button" class="regler-button" onclick="updateStatus('<?php echo e($appointment->id); ?>', 'regler')">Regler</button>
    <button type="button" class="cancel-button" onclick="updateStatus('<?php echo e($appointment->id); ?>', 'annuler')">Annuler</button>
            <div class="price-toggle">
            <label for="regler-radio">Modifier prix</label>
            <input type="radio" id="regler-radio_<?php echo e($appointment->id); ?>" name="regler" onclick="togglePriceField('<?php echo e($appointment->id); ?>')">
        </div>
            <div class="price-container">
                <label for="prix_rv" id="prix_rv_label_<?php echo e($appointment->id); ?>" class="price-label" style="display: none;">Prix:</label>
                <input type="text" id="prix_rv_<?php echo e($appointment->id); ?>" name="prix_rv" value="<?php echo e($appointment->prix_rv); ?>" class="price-input" style="display: none;">
            </div>
            <!-- <button type="submit" class="update-status-button">Modifier</button> -->
        </form>
        <a class="fiche-client-button" href="<?php echo e(route('fiche_clients.index', ['prospect_id' => $appointment->prospect->id])); ?>">Fiche Client</a>
      
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


<div id="popup-overlay" class="popup-overlay"></div>

    <script>
        
function showPopup(header, description, eventBox, appointmentId) {
    var popup = document.getElementById('popup-' + appointmentId); // Append the appointment ID
    var content = popup.querySelector('.popup-content');

    popup.style.display = 'block';
    setTimeout(function() {
        content.classList.add('show');
    }, 50);

    document.getElementById('popup-header').innerText = header;
    document.getElementById('popup-description').innerText = description;

    // Pass the event box element to the handleButtonClick function
    var buttons = popup.querySelectorAll('button');
    for (var i = 0; i < buttons.length; i++) {
        buttons[i].addEventListener('click', function() {
            handleButtonClick(this, eventBox);
        });
    }
}

function hidePopup(appointmentId) {
            var popup = document.getElementById('popup-' + appointmentId);
            var content = popup.querySelector('.popup-content');

            content.classList.remove('show');
            setTimeout(function() {
                popup.style.display = 'none';
            }, 300);
        }
        function togglePriceField(appointmentId) {
        var radio = document.getElementById('regler-radio_' + appointmentId);
        var priceLabel = document.getElementById('prix_rv_label_' + appointmentId);
        var priceField = document.getElementById('prix_rv_' + appointmentId);
        if (radio.checked) {
            priceLabel.style.display = 'block';
            priceField.style.display = 'block';
            // Change the value of the status select to "regler" when the radio button is checked
            document.getElementById('statu').value = 'regler';
        } else {
            priceLabel.style.display = 'none';
            priceField.style.display = 'none';
            // Reset the value of the status select when the radio button is unchecked
            document.getElementById('statu').value = '';
        }
    }
    document.getElementById('select-date').addEventListener('change', function() {
    var selectedDate = this.value;
    var currentDateElement = document.getElementById('current-date');
    var eventBoxes = document.querySelectorAll('.event-box');

    // Update current date display
    currentDateElement.innerText = "aujourd'hui:" + selectedDate;

    // Loop through event boxes and show/hide based on selected date
    eventBoxes.forEach(function(eventBox) {
        var eventDate = eventBox.getAttribute('data-date');

        console.log('Event Date:', eventDate);
        console.log('Selected Date:', selectedDate);

        if (eventDate === selectedDate) {
            eventBox.style.display = 'block';
        } else {
            eventBox.style.display = 'none';
        }
    });
});

// Initially, show only appointments for today
document.getElementById('select-date').value = "<?php echo e(date('Y-m-d')); ?>";
document.getElementById('select-date').dispatchEvent(new Event('change'));

function updateStatus(appointmentId, status) {
    // Set the status value
    document.getElementById('statu-' + appointmentId).value = status;
    // Submit the form
    document.getElementById('status-form-' + appointmentId).submit();
}


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lasercli/public_html/app.laserclinic.ma/resources/views/home.blade.php ENDPATH**/ ?>